//Falcon-180B DATASET v1.0 Category: System process viewer ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PROCESSES 100
#define MAX_PROCESS_NAME_LENGTH 32

typedef struct {
    char process_name[MAX_PROCESS_NAME_LENGTH];
    int process_id;
    int process_status;
} process_t;

process_t processes[MAX_PROCESSES];
int num_processes = 0;

void add_process(char* process_name, int process_id, int process_status) {
    if (num_processes >= MAX_PROCESSES) {
        printf("Error: Maximum number of processes reached.\n");
        return;
    }

    strncpy(processes[num_processes].process_name, process_name, MAX_PROCESS_NAME_LENGTH);
    processes[num_processes].process_id = process_id;
    processes[num_processes].process_status = process_status;

    num_processes++;
}

void remove_process(int process_id) {
    for (int i = 0; i < num_processes; i++) {
        if (processes[i].process_id == process_id) {
            processes[i] = processes[num_processes - 1];
            num_processes--;
            return;
        }
    }
}

void update_process_status(int process_id, int process_status) {
    for (int i = 0; i < num_processes; i++) {
        if (processes[i].process_id == process_id) {
            processes[i].process_status = process_status;
            return;
        }
    }
}

void print_processes() {
    printf("Process ID\tProcess Name\tStatus\n");
    for (int i = 0; i < num_processes; i++) {
        printf("%d\t%s\t%d\n", processes[i].process_id, processes[i].process_name, processes[i].process_status);
    }
}

int main() {
    add_process("Process 1", 1, 1);
    add_process("Process 2", 2, 2);
    add_process("Process 3", 3, 3);

    print_processes();

    remove_process(2);

    print_processes();

    update_process_status(1, 4);

    print_processes();

    return 0;
}