//GEMINI-pro DATASET v1.0 Category: Maze Route Finder ; Style: futuristic
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#define MAX_SIZE 100

typedef struct {
  int x;
  int y;
} Point;

typedef struct {
  char grid[MAX_SIZE][MAX_SIZE];
  int width;
  int height;
} Maze;

bool is_valid_point(Maze *maze, Point point) {
  return point.x >= 0 && point.x < maze->width && point.y >= 0 && point.y < maze->height && maze->grid[point.y][point.x] != '#';
}

bool is_goal(Maze *maze, Point point) {
  return point.x == maze->width - 1 && point.y == maze->height - 1;
}

void print_maze(Maze *maze) {
  for (int i = 0; i < maze->height; i++) {
    for (int j = 0; j < maze->width; j++) {
      printf("%c", maze->grid[i][j]);
    }
    printf("\n");
  }
}

bool find_path(Maze *maze, Point start, Point *path, int *path_length) {
  if (!is_valid_point(maze, start)) {
    return false;
  }

  *path_length = 0;
  path[*path_length] = start;

  while (!is_goal(maze, start)) {
    // Try to move in all four directions
    Point directions[] = {{0, 1}, {0, -1}, {1, 0}, {-1, 0}};
    for (int i = 0; i < 4; i++) {
      Point next = {start.x + directions[i].x, start.y + directions[i].y};
      if (is_valid_point(maze, next)) {
        *path_length += 1;
        path[*path_length] = next;
        start = next;
        break;
      }
    }

    // If no valid move was found, backtrack
    if (!is_goal(maze, start)) {
      *path_length -= 1;
      start = path[*path_length];
    }
  }

  return true;
}

int main() {
  // Define the maze
  Maze maze = {
    .grid = {
      "####################################################",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "#                                                  #",
      "####################################################"
    },
    .width = 50,
    .height = 20
  };

  // Find the path
  Point start = {0, 0};
  Point path[MAX_SIZE];
  int path_length;
  bool found = find_path(&maze, start, path, &path_length);

  // Print the path
  if (found) {
    printf("Path found:\n");
    for (int i = 0; i <= path_length; i++) {
      printf("(%d, %d)\n", path[i].x, path[i].y);
    }
  } else {
    printf("No path found.\n");
  }

  return 0;
}