//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CARS 10

typedef struct Car
{
    int position;
    int direction;
    int speed;
    int lane;
} Car;

Car cars[MAX_CARS];

void initializeCars()
{
    for (int i = 0; i < MAX_CARS; i++)
    {
        cars[i].position = 0;
        cars[i].direction = 1;
        cars[i].speed = 1;
        cars[i].lane = 0;
    }
}

void moveCars()
{
    for (int i = 0; i < MAX_CARS; i++)
    {
        switch (cars[i].direction)
        {
            case 1:
                cars[i].position++;
                break;
            case -1:
                cars[i].position--;
                break;
        }

        if (cars[i].position >= 10)
        {
            cars[i].direction = -1;
        }
        if (cars[i].position <= 0)
        {
            cars[i].direction = 1;
        }
    }
}

void printTrafficFlow()
{
    for (int i = 0; i < MAX_CARS; i++)
    {
        printf("Car %d: Position %d, Direction %d, Lane %d\n", i + 1, cars[i].position, cars[i].direction, cars[i].lane);
    }
}

int main()
{
    initializeCars();

    for (int t = 0; t < 10; t++)
    {
        moveCars();
        printTrafficFlow();
        printf("\n");
    }

    return 0;
}