//GEMINI-pro DATASET v1.0 Category: Chess engine ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BOARD_SIZE 8
#define WHITE 1
#define BLACK -1

typedef struct {
    int x;
    int y;
} Position;

typedef struct {
    int type;
    Position position;
} Piece;

typedef struct {
    Piece pieces[BOARD_SIZE * BOARD_SIZE];
} Board;

void initBoard(Board *board) {
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            board->pieces[i * BOARD_SIZE + j].type = 0;
            board->pieces[i * BOARD_SIZE + j].position.x = i;
            board->pieces[i * BOARD_SIZE + j].position.y = j;
        }
    }

    // White pieces
    board->pieces[0].type = 1; // Rook
    board->pieces[1].type = 2; // Knight
    board->pieces[2].type = 3; // Bishop
    board->pieces[3].type = 4; // Queen
    board->pieces[4].type = 5; // King
    board->pieces[5].type = 3; // Bishop
    board->pieces[6].type = 2; // Knight
    board->pieces[7].type = 1; // Rook
    for (int i = 0; i < BOARD_SIZE; i++) {
        board->pieces[i + 8].type = 6; // Pawn
    }

    // Black pieces
    board->pieces[BOARD_SIZE * BOARD_SIZE - 1].type = 1; // Rook
    board->pieces[BOARD_SIZE * BOARD_SIZE - 2].type = 2; // Knight
    board->pieces[BOARD_SIZE * BOARD_SIZE - 3].type = 3; // Bishop
    board->pieces[BOARD_SIZE * BOARD_SIZE - 4].type = 4; // Queen
    board->pieces[BOARD_SIZE * BOARD_SIZE - 5].type = 5; // King
    board->pieces[BOARD_SIZE * BOARD_SIZE - 6].type = 3; // Bishop
    board->pieces[BOARD_SIZE * BOARD_SIZE - 7].type = 2; // Knight
    board->pieces[BOARD_SIZE * BOARD_SIZE - 8].type = 1; // Rook
    for (int i = 0; i < BOARD_SIZE; i++) {
        board->pieces[BOARD_SIZE * (BOARD_SIZE - 2) + i].type = -6; // Pawn
    }
}

void printBoard(Board *board) {
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            switch (board->pieces[i * BOARD_SIZE + j].type) {
                case 1:
                    printf("R");
                    break;
                case 2:
                    printf("N");
                    break;
                case 3:
                    printf("B");
                    break;
                case 4:
                    printf("Q");
                    break;
                case 5:
                    printf("K");
                    break;
                case 6:
                    printf("P");
                    break;
                case -1:
                    printf("r");
                    break;
                case -2:
                    printf("n");
                    break;
                case -3:
                    printf("b");
                    break;
                case -4:
                    printf("q");
                    break;
                case -5:
                    printf("k");
                    break;
                case -6:
                    printf("p");
                    break;
                default:
                    printf("-");
                    break;
            }
        }
        printf("\n");
    }
}

int main() {
    Board board;
    initBoard(&board);
    printBoard(&board);
    return 0;
}