//GEMINI-pro DATASET v1.0 Category: Table Game ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PLAYERS 4
#define MAX_CARDS 52

typedef struct {
    int value;
    char suit;
} Card;

typedef struct {
    Card cards[MAX_CARDS];
    int num_cards;
} Hand;

typedef struct {
    int players[MAX_PLAYERS];
    int num_players;
} Table;

void init_table(Table *table) {
    table->num_players = 0;
    for (int i = 0; i < MAX_PLAYERS; i++) {
        table->players[i] = -1;
    }
}

void add_player(Table *table, int player_id) {
    if (table->num_players >= MAX_PLAYERS) {
        printf("Error: table is full\n");
        return;
    }

    table->players[table->num_players] = player_id;
    table->num_players++;
}

void remove_player(Table *table, int player_id) {
    for (int i = 0; i < table->num_players; i++) {
        if (table->players[i] == player_id) {
            table->players[i] = table->players[table->num_players - 1];
            table->num_players--;
            return;
        }
    }

    printf("Error: player not found\n");
}

void init_hand(Hand *hand) {
    hand->num_cards = 0;
}

void add_card(Hand *hand, Card card) {
    if (hand->num_cards >= MAX_CARDS) {
        printf("Error: hand is full\n");
        return;
    }

    hand->cards[hand->num_cards] = card;
    hand->num_cards++;
}

void remove_card(Hand *hand, int index) {
    if (index < 0 || index >= hand->num_cards) {
        printf("Error: invalid index\n");
        return;
    }

    for (int i = index; i < hand->num_cards - 1; i++) {
        hand->cards[i] = hand->cards[i + 1];
    }

    hand->num_cards--;
}

void print_hand(Hand hand) {
    for (int i = 0; i < hand.num_cards; i++) {
        printf("%d%c ", hand.cards[i].value, hand.cards[i].suit);
    }

    printf("\n");
}

int main() {
    Table table;
    Hand hand;

    init_table(&table);
    add_player(&table, 0);
    add_player(&table, 1);
    add_player(&table, 2);

    init_hand(&hand);
    add_card(&hand, (Card) { .value = 2, .suit = 'C' });
    add_card(&hand, (Card) { .value = 3, .suit = 'D' });
    add_card(&hand, (Card) { .value = 4, .suit = 'H' });

    print_hand(hand);

    return 0;
}