//GEMINI-pro DATASET v1.0 Category: Personal Finance Planner ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of transactions
#define MAX_TRANSACTIONS 100

// Define the structure of a transaction
typedef struct {
    char description[50];
    double amount;
    char type; // 'I' for income, 'E' for expense
} transaction;

// Declare the array of transactions
transaction transactions[MAX_TRANSACTIONS];

// Declare the number of transactions
int num_transactions = 0;

// Function to add a transaction
void add_transaction(char *description, double amount, char type) {
    // Check if the array of transactions is full
    if (num_transactions == MAX_TRANSACTIONS) {
        printf("Error: The array of transactions is full.\n");
        return;
    }

    // Add the transaction to the array
    strcpy(transactions[num_transactions].description, description);
    transactions[num_transactions].amount = amount;
    transactions[num_transactions].type = type;

    // Increment the number of transactions
    num_transactions++;
}

// Function to print the transactions
void print_transactions() {
    // Print the header
    printf("%-50s %-10s %-10s\n", "Description", "Amount", "Type");

    // Print the transactions
    for (int i = 0; i < num_transactions; i++) {
        printf("%-50s %-10.2f %-10c\n", transactions[i].description, transactions[i].amount, transactions[i].type);
    }
}

// Function to calculate the total income
double calculate_total_income() {
    // Initialize the total income to 0
    double total_income = 0;

    // Iterate over the transactions
    for (int i = 0; i < num_transactions; i++) {
        // If the transaction is an income, add it to the total income
        if (transactions[i].type == 'I') {
            total_income += transactions[i].amount;
        }
    }

    // Return the total income
    return total_income;
}

// Function to calculate the total expense
double calculate_total_expense() {
    // Initialize the total expense to 0
    double total_expense = 0;

    // Iterate over the transactions
    for (int i = 0; i < num_transactions; i++) {
        // If the transaction is an expense, add it to the total expense
        if (transactions[i].type == 'E') {
            total_expense += transactions[i].amount;
        }
    }

    // Return the total expense
    return total_expense;
}

// Function to calculate the net income
double calculate_net_income() {
    // Calculate the total income and total expense
    double total_income = calculate_total_income();
    double total_expense = calculate_total_expense();

    // Calculate the net income
    double net_income = total_income - total_expense;

    // Return the net income
    return net_income;
}

// Main function
int main() {
    // Add some sample transactions
    add_transaction("Salary", 2000, 'I');
    add_transaction("Rent", -500, 'E');
    add_transaction("Groceries", -100, 'E');
    add_transaction("Entertainment", -50, 'E');

    // Print the transactions
    print_transactions();

    // Calculate the total income, total expense, and net income
    double total_income = calculate_total_income();
    double total_expense = calculate_total_expense();
    double net_income = calculate_net_income();

    // Print the total income, total expense, and net income
    printf("Total income: $%.2f\n", total_income);
    printf("Total expense: $%.2f\n", total_expense);
    printf("Net income: $%.2f\n", net_income);

    return 0;
}