//Falcon2-11B DATASET v1.0 Category: Game of Life ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int main() {
    int board[10][10];
    int i, j, aliveCells;

    srand(time(NULL));

    for (i = 0; i < 10; i++) {
        for (j = 0; j < 10; j++) {
            board[i][j] = rand() % 2;
        }
    }

    aliveCells = 0;
    for (i = 0; i < 10; i++) {
        for (j = 0; j < 10; j++) {
            if (board[i][j] == 1) {
                aliveCells++;
            }
        }
    }

    printf("Initial state: ");
    for (i = 0; i < 10; i++) {
        for (j = 0; j < 10; j++) {
            printf("%d ", board[i][j]);
        }
        printf("\n");
    }

    printf("Alive cells: %d\n", aliveCells);

    // Game of Life rules
    for (i = 0; i < 10; i++) {
        for (j = 0; j < 10; j++) {
            int neighbors = 0;
            if (i > 0 && board[i - 1][j] == 1) neighbors++;
            if (j > 0 && board[i][j - 1] == 1) neighbors++;
            if (i < 9 && board[i + 1][j] == 1) neighbors++;
            if (j < 9 && board[i][j + 1] == 1) neighbors++;
            if (i > 0 && j > 0 && board[i - 1][j - 1] == 1) neighbors++;
            if (i > 0 && j < 9 && board[i - 1][j + 1] == 1) neighbors++;
            if (i < 9 && j > 0 && board[i + 1][j - 1] == 1) neighbors++;
            if (i < 9 && j < 9 && board[i + 1][j + 1] == 1) neighbors++;

            if (board[i][j] == 1 && neighbors < 2) {
                board[i][j] = 0;
            } else if (board[i][j] == 0 && neighbors == 3) {
                board[i][j] = 1;
            }
        }
    }

    printf("New state: ");
    for (i = 0; i < 10; i++) {
        for (j = 0; j < 10; j++) {
            printf("%d ", board[i][j]);
        }
        printf("\n");
    }

    return 0;
}