//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of products that can be stored in the warehouse
#define MAX_PRODUCTS 100

// Define the structure of a product
typedef struct Product {
    char name[50];
    int quantity;
    float price;
} Product;

// Declare an array of products
Product products[MAX_PRODUCTS];

// Declare the number of products currently stored in the warehouse
int num_products = 0;

// Function to add a product to the warehouse
void add_product(char* name, int quantity, float price) {
    // Check if there is space in the warehouse for a new product
    if (num_products >= MAX_PRODUCTS) {
        printf("Warehouse is full. Cannot add product.\n");
        return;
    }

    // Add the product to the warehouse
    strcpy(products[num_products].name, name);
    products[num_products].quantity = quantity;
    products[num_products].price = price;

    // Increment the number of products in the warehouse
    num_products++;

    printf("Product added successfully.\n");
}

// Function to remove a product from the warehouse
void remove_product(char* name) {
    // Search for the product in the warehouse
    int i;
    for (i = 0; i < num_products; i++) {
        if (strcmp(products[i].name, name) == 0) {
            // Remove the product from the warehouse
            num_products--;

            // Shift the remaining products to fill the gap
            for (int j = i; j < num_products; j++) {
                strcpy(products[j].name, products[j+1].name);
                products[j].quantity = products[j+1].quantity;
                products[j].price = products[j+1].price;
            }

            printf("Product removed successfully.\n");
            return;
        }
    }

    // Product not found in the warehouse
    printf("Product not found.\n");
}

// Function to display the contents of the warehouse
void display_warehouse() {
    printf("Warehouse contents:\n");
    printf("--------------------\n");
    printf("Product Name\tQuantity\tPrice\n");

    int i;
    for (i = 0; i < num_products; i++) {
        printf("%s\t\t%d\t\t%.2f\n", products[i].name, products[i].quantity, products[i].price);
    }
}

// Main function
int main() {
    // Add some products to the warehouse
    add_product("Apple", 100, 1.00);
    add_product("Banana", 50, 0.50);
    add_product("Orange", 25, 0.75);

    // Display the contents of the warehouse
    display_warehouse();

    // Remove a product from the warehouse
    remove_product("Banana");

    // Display the contents of the warehouse again
    display_warehouse();

    return 0;
}