//Falcon2-11B DATASET v1.0 Category: Warehouse Management System ; Style: modular
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct {
    char name[50];
    float price;
    int quantity;
} Item;

Item items[MAX_ITEMS];
int numItems = 0;

void addItem(const char *name, float price, int quantity) {
    Item newItem;
    strcpy(newItem.name, name);
    newItem.price = price;
    newItem.quantity = quantity;

    items[numItems] = newItem;
    numItems++;
}

void removeItem(int index) {
    if (index >= 0 && index < numItems) {
        items[index] = items[numItems - 1];
        numItems--;
    }
}

void displayItems() {
    printf("Item\t\tPrice\t\tQuantity\n");
    for (int i = 0; i < numItems; i++) {
        printf("%s\t\t%f\t\t%d\n", items[i].name, items[i].price, items[i].quantity);
    }
}

float calculateTotalValue() {
    float total = 0.0;
    for (int i = 0; i < numItems; i++) {
        total += items[i].price * items[i].quantity;
    }
    return total;
}

int main() {
    addItem("Laptop", 1000.0, 10);
    addItem("Mouse", 20.0, 5);
    addItem("Keyboard", 50.0, 3);

    displayItems();
    printf("Total Value: $%.2f\n", calculateTotalValue());

    removeItem(0);
    displayItems();

    return 0;
}