//LLAMA2-13B DATASET v1.0 Category: Digital Diary ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#define DAY_COUNT 30
#define MONTH_COUNT 12
#define YEAR_COUNT 10

// Structure to store date and emotion data
typedef struct {
    int day;
    int month;
    int year;
    char emotion[50];
} diary_entry_t;

// Function to calculate the number of days since the beginning of the year
int get_days_since_beginning_of_year(int year, int month, int day) {
    int days = 0;
    if (month <= 3) { // March is the first month of the year
        days += (31 * (month - 1)) + day;
    } else if (month <= 6) {
        days += (30 * (month - 1)) + day;
    } else if (month <= 9) {
        days += (30 * (month - 2)) + (31 * (month - 1)) + day;
    } else {
        days += (31 * (month - 2)) + (30 * (month - 1)) + day;
    }
    return days;
}

// Function to calculate the number of days since the beginning of the month
int get_days_since_beginning_of_month(int month, int day) {
    int days = 0;
    if (month <= 3) { // March is the first month of the year
        days += (31 * (month - 1)) + day;
    } else if (month <= 6) {
        days += (30 * (month - 1)) + day;
    } else if (month <= 9) {
        days += (30 * (month - 2)) + (31 * (month - 1)) + day;
    } else {
        days += (31 * (month - 2)) + (30 * (month - 1)) + day;
    }
    return days;
}

// Function to calculate the number of days since the beginning of the year, taking into account leap years
int get_days_since_beginning_of_year_leap(int year, int month, int day) {
    int days = 0;
    if (month <= 3) { // March is the first month of the year
        days += (31 * (month - 1)) + day;
    } else if (month <= 6) {
        days += (30 * (month - 1)) + day;
    } else if (month <= 9) {
        days += (30 * (month - 2)) + (31 * (month - 1)) + day;
    } else {
        days += (31 * (month - 2)) + (30 * (month - 1)) + day;
    }
    if (year % 4 == 0) {
        days++; // Leap year
    }
    return days;
}

// Function to write a diary entry to a file
void write_diary_entry(diary_entry_t entry) {
    FILE *file = fopen("diary.txt", "a");
    fprintf(file, "%d/%d/%d - %s\n", entry.day, entry.month, entry.year, entry.emotion);
    fclose(file);
}

int main() {
    // Initialize variables for date and emotion
    int day = 1;
    int month = 3; // March is the first month of the year
    int year = 2023;
    char emotion[50] = "Happy";

    // Calculate the number of days since the beginning of the year
    int days_since_beginning_of_year = get_days_since_beginning_of_year(year, month, day);

    // Calculate the number of days since the beginning of the month
    int days_since_beginning_of_month = get_days_since_beginning_of_month(month, day);

    // Calculate the number of days since the beginning of the year, taking into account leap years
    int days_since_beginning_of_year_leap = get_days_since_beginning_of_year_leap(year, month, day);

    // Write the diary entry to a file
    diary_entry_t entry = {day, month, year, emotion};
    write_diary_entry(entry);

    // Print the number of days since the beginning of the year, the number of days since the beginning of the month, and the number of days since the beginning of the year (leap year)
    printf("Days since beginning of year: %d\n", days_since_beginning_of_year);
    printf("Days since beginning of month: %d\n", days_since_beginning_of_month);
    printf("Days since beginning of year (leap year): %d\n", days_since_beginning_of_year_leap);

    return 0;
}