//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define DAYS 7
#define MAX_TEMP 40
#define MIN_TEMP -10
#define MAX_HUMIDITY 100
#define MIN_HUMIDITY 0

typedef struct {
    int day;
    float temperature; // Temperature in Celsius
    float humidity;    // Humidity in percentage
} WeatherDay;

void generateWeather(WeatherDay *weather) {
    for (int i = 0; i < DAYS; i++) {
        weather[i].day = i + 1;
        weather[i].temperature = (rand() % (MAX_TEMP - MIN_TEMP + 1)) + MIN_TEMP;
        weather[i].humidity = (rand() % (MAX_HUMIDITY - MIN_HUMIDITY + 1)) + MIN_HUMIDITY;
    }
}

void printWeather(const WeatherDay *weather) {
    printf("Weather Forecast for the next %d days:\n", DAYS);
    printf("Day\tTemperature (°C)\tHumidity (%%)\n");
    printf("--------------------------------------------\n");
    for (int i = 0; i < DAYS; i++) {
        printf("%d\t%.2f\t\t\t%.2f\n", weather[i].day, weather[i].temperature, weather[i].humidity);
    }
}

void printSummary(const WeatherDay *weather) {
    float avgTemp = 0;
    float avgHumidity = 0;
    float maxTemp = MIN_TEMP;
    float minTemp = MAX_TEMP;

    for (int i = 0; i < DAYS; i++) {
        avgTemp += weather[i].temperature;
        avgHumidity += weather[i].humidity;
        if (weather[i].temperature > maxTemp) {
            maxTemp = weather[i].temperature;
        }
        if (weather[i].temperature < minTemp) {
            minTemp = weather[i].temperature;
        }
    }

    avgTemp /= DAYS;
    avgHumidity /= DAYS;

    printf("\nWeather Summary:\n");
    printf("Average Temperature: %.2f°C\n", avgTemp);
    printf("Max Temperature: %.2f°C\n", maxTemp);
    printf("Min Temperature: %.2f°C\n", minTemp);
    printf("Average Humidity: %.2f%%\n", avgHumidity);
}

int main() {
    srand(time(0)); // Seed for random number generation
    WeatherDay weather[DAYS];

    generateWeather(weather);
    printWeather(weather);
    printSummary(weather);

    return 0;
}