//Falcon-180B DATASET v1.0 Category: Bucket Sort Implementation ; Style: curious
#include <stdio.h>

#define MAX_SIZE 100

void insert(int arr[], int n, int key) {
    int i;
    for (i = n - 1; i >= 0; i--) {
        if (arr[i] > key) {
            arr[i + 1] = arr[i];
        } else {
            break;
        }
    }
    arr[i + 1] = key;
}

void bucket_sort(int arr[], int n) {
    int i, j, k, max, min;
    int buckets[MAX_SIZE];
    int count[MAX_SIZE] = {0};

    // Find the maximum and minimum values in the array
    max = arr[0];
    min = arr[0];
    for (i = 1; i < n; i++) {
        if (arr[i] > max) {
            max = arr[i];
        } else if (arr[i] < min) {
            min = arr[i];
        }
    }

    // Create the buckets
    for (i = 0; i <= max - min + 1; i++) {
        buckets[i] = -1;
    }

    // Insert the elements into the buckets
    for (i = 0; i < n; i++) {
        k = (arr[i] - min) / (max - min + 1);
        if (buckets[k] == -1) {
            buckets[k] = i;
        } else {
            insert(buckets, k, i);
        }
    }

    // Sort the elements in each bucket
    for (i = 0; i <= max - min + 1; i++) {
        if (buckets[i]!= -1) {
            for (j = 0; j < count[i]; j++) {
                arr[j] = buckets[i];
                j++;
            }
            count[i] = 0;
        }
    }
}

int main() {
    int arr[] = { 10, 7, 8, 9, 1, 5 };
    int n = sizeof(arr) / sizeof(arr[0]);

    printf("Unsorted array: ");
    for (int i = 0; i < n; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");

    bucket_sort(arr, n);

    printf("Sorted array: ");
    for (int i = 0; i < n; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");

    return 0;
}