//GEMINI-pro DATASET v1.0 Category: Networking ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main() {
  int server_fd, new_socket, valread;
  struct sockaddr_in address;
  int addrlen = sizeof(address);
  char buffer[1024] = {0};
  char *hello = "Hello from the server!";

  // Creating socket file descriptor
  if ((server_fd = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
    perror("socket failed");
    exit(EXIT_FAILURE);
  } else {
    printf("Socket created.\n");
  }

  // Setting socket options
  int reuse = 1;
  if (setsockopt(server_fd, SOL_SOCKET, SO_REUSEADDR | SO_REUSEPORT, &reuse,
                 sizeof(reuse))) {
    perror("setsockopt failed");
    exit(EXIT_FAILURE);
  } else {
    printf("Socket options set.\n");
  }

  address.sin_family = AF_INET;
  address.sin_addr.s_addr = INADDR_ANY;
  address.sin_port = htons(PORT);

  // Binding the socket to the address
  if (bind(server_fd, (struct sockaddr *)&address, addrlen) < 0) {
    perror("bind failed");
    exit(EXIT_FAILURE);
  } else {
    printf("Socket bound to port %d.\n", PORT);
  }

  // Listening on the socket with a max of 3 pending connections
  if (listen(server_fd, 3) < 0) {
    perror("listen failed");
    exit(EXIT_FAILURE);
  } else {
    printf("Listening on port %d.\n", PORT);
  }

  // Accepting a client connection
  if ((new_socket = accept(server_fd, (struct sockaddr *)&address,
                           (socklen_t *)&addrlen)) < 0) {
    perror("accept failed");
    exit(EXIT_FAILURE);
  } else {
    printf("Connection accepted from %s:%d.\n", inet_ntoa(address.sin_addr),
           ntohs(address.sin_port));
  }

  // Reading data from the client
  valread = read(new_socket, buffer, 1024);
  if (valread < 0) {
    perror("read failed");
    exit(EXIT_FAILURE);
  } else {
    printf("Received %d bytes from client: %s\n", valread, buffer);
  }

  // Sending data to the client
  send(new_socket, hello, strlen(hello), 0);
  printf("Sent %d bytes to client: %s\n", strlen(hello), hello);

  // Closing the client connection
  close(new_socket);
  printf("Connection closed.\n");

  // Closing the server socket
  close(server_fd);
  printf("Server socket closed.\n");

  return 0;
}