//GPT-4o-mini DATASET v1.0 Category: Image Classification system ; Style: recursive
#include <stdio.h>
#include <string.h>

#define MAX_IMAGES 100
#define IMAGE_NAME_LENGTH 100

typedef struct {
    char name[IMAGE_NAME_LENGTH];
    char label[20];
} Image;

// Sample images for demonstration
Image images[MAX_IMAGES] = {
    {"cat1.jpg", "Cat"}, {"dog1.jpg", "Dog"}, {"cat2.jpg", "Cat"},
    {"dog2.jpg", "Dog"}, {"cat3.jpg", "Cat"}, {"dog3.jpg", "Dog"},
    {"parrot.jpg", "Bird"}, {"fish1.jpg", "Fish"}, {"fish2.jpg", "Fish"},
};

int imageCount = 9;

void classifyImage(const char* imageName, int currentIndex) {
    if (currentIndex >= imageCount) {
        printf("Image %s not found. Classification failed.\n", imageName);
        return;
    }

    // Check if the current image matches the search for classification
    if (strcmp(images[currentIndex].name, imageName) == 0) {
        printf("Image %s is classified as: %s\n", images[currentIndex].name, images[currentIndex].label);
        return;
    } else {
        // Recursive case: Move to the next image
        classifyImage(imageName, currentIndex + 1);
    }
}

void classifyImagesRecursively(const char* imageNames[], int length, int currentIndex) {
    if (currentIndex >= length) {
        printf("All classifications checked.\n");
        return;
    }
    
    classifyImage(imageNames[currentIndex], 0);
    classifyImagesRecursively(imageNames, length, currentIndex + 1);
}

int main() {
    const char* imagesToClassify[] = {"dog1.jpg", "cat3.jpg", "parrot.jpg", "fish1.jpg", "unknown.jpg"};
    int numImages = sizeof(imagesToClassify) / sizeof(imagesToClassify[0]);

    printf("Starting image classification...\n");
    classifyImagesRecursively(imagesToClassify, numImages, 0);
    
    return 0;
}