//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the possible weather conditions
#define SUNNY 0
#define RAINY 1
#define SNOWY 2
#define STORMY 3

// Define the probability of each weather condition
#define SUNNY_PROB 0.5
#define RAINY_PROB 0.25
#define SNOWY_PROB 0.15
#define STORMY_PROB 0.1

// Define the minimum and maximum temperature for each weather condition
#define SUNNY_MIN_TEMP 10
#define SUNNY_MAX_TEMP 25
#define RAINY_MIN_TEMP 5
#define RAINY_MAX_TEMP 15
#define SNOWY_MIN_TEMP -5
#define SNOWY_MAX_TEMP 5
#define STORMY_MIN_TEMP -10
#define STORMY_MAX_TEMP 0

// Get a random weather condition
int get_weather_condition() {
  double r = (double)rand() / (double)RAND_MAX;

  if (r < SUNNY_PROB) {
    return SUNNY;
  } else if (r < SUNNY_PROB + RAINY_PROB) {
    return RAINY;
  } else if (r < SUNNY_PROB + RAINY_PROB + SNOWY_PROB) {
    return SNOWY;
  } else {
    return STORMY;
  }
}

// Get a random temperature for the given weather condition
int get_temperature(int weather_condition) {
  int min_temp, max_temp;

  switch (weather_condition) {
  case SUNNY:
    min_temp = SUNNY_MIN_TEMP;
    max_temp = SUNNY_MAX_TEMP;
    break;
  case RAINY:
    min_temp = RAINY_MIN_TEMP;
    max_temp = RAINY_MAX_TEMP;
    break;
  case SNOWY:
    min_temp = SNOWY_MIN_TEMP;
    max_temp = SNOWY_MAX_TEMP;
    break;
  case STORMY:
    min_temp = STORMY_MIN_TEMP;
    max_temp = STORMY_MAX_TEMP;
    break;
  }

  return (rand() % (max_temp - min_temp + 1)) + min_temp;
}

// Print the weather forecast
void print_weather_forecast(int weather_condition, int temperature) {
  switch (weather_condition) {
  case SUNNY:
    printf("Sunny");
    break;
  case RAINY:
    printf("Rainy");
    break;
  case SNOWY:
    printf("Snowy");
    break;
  case STORMY:
    printf("Stormy");
    break;
  }

  printf(" with a temperature of %d degrees Celsius.\n", temperature);
}

int main() {
  // Initialize the random number generator
  srand(time(NULL));

  // Get the weather condition and temperature
  int weather_condition = get_weather_condition();
  int temperature = get_temperature(weather_condition);

  // Print the weather forecast
  print_weather_forecast(weather_condition, temperature);

  return 0;
}