//Falcon-180B DATASET v1.0 Category: Website Uptime Monitor ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#define MAX_URL_SIZE 1000
#define MAX_RESPONSE_SIZE 1000000

int is_url_up(const char *url);
void write_to_file(const char *filename, const char *data);

int main(int argc, char **argv) {
    if (argc < 2) {
        printf("Usage: %s <url>\n", argv[0]);
        return 1;
    }

    const char *url = argv[1];
    char response[MAX_RESPONSE_SIZE];
    int response_code;

    if (is_url_up(url)) {
        printf("URL is up!\n");
    } else {
        printf("URL is down!\n");
    }

    return 0;
}

int is_url_up(const char *url) {
    CURL *curl;
    FILE *fp;
    CURLcode res;

    curl = curl_easy_init();
    if (curl) {
        fp = fopen("/dev/null", "wb");
        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_to_file);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, fp);
        res = curl_easy_perform(curl);
        fclose(fp);
        curl_easy_cleanup(curl);

        if (res == CURLE_OK) {
            return 1;
        }
    }

    return 0;
}

void write_to_file(const char *filename, const char *data) {
    int fd = open(filename, O_WRONLY | O_CREAT, 0644);
    if (fd < 0) {
        printf("Error opening file %s\n", filename);
        return;
    }

    write(fd, data, strlen(data));
    close(fd);
}