//Falcon-180B DATASET v1.0 Category: Database Indexing System ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_KEY_LENGTH 100
#define MAX_VALUE_LENGTH 1000
#define MAX_NUM_KEYS 1000
#define MAX_NUM_VALUES 10000

typedef struct {
    char key[MAX_KEY_LENGTH];
    char value[MAX_VALUE_LENGTH];
} KeyValue;

int numKeys = 0;
KeyValue keys[MAX_NUM_KEYS];

int compareKeys(const void *a, const void *b) {
    return strcmp(*(char **)a, *(char **)b);
}

void addKey(char *key, char *value) {
    if (numKeys >= MAX_NUM_KEYS) {
        printf("Error: Maximum number of keys reached.\n");
        return;
    }

    strcpy(keys[numKeys].key, key);
    strcpy(keys[numKeys].value, value);

    numKeys++;
}

void searchKey(char *key) {
    KeyValue *result = bsearch(&key, keys, numKeys, sizeof(KeyValue), compareKeys);

    if (result == NULL) {
        printf("Key not found.\n");
    } else {
        printf("Value: %s\n", result->value);
    }
}

int main() {
    addKey("apple", "red");
    addKey("banana", "yellow");
    addKey("cherry", "red");

    searchKey("apple");
    searchKey("orange");

    return 0;
}