//Falcon-180B DATASET v1.0 Category: Tower of Hanoi Problem ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX 100

// Function to print the tower of Hanoi
void printTower(int n, char from, char to, char aux)
{
    int i;
    for (i = 0; i < n; i++) {
        if (i == 0)
            printf("Move disk 1 from %c to %c\n", from, to);
        else if (i == n - 1)
            printf("Move disk %d from %c to %c\n", n, from, to);
        else
            printf("Move disk %d from %c to %c\n", i + 1, from, to);
    }
}

// Function to check if the move is valid
int isValidMove(int n, int from, int to, int aux)
{
    // If the move is from source to destination or from source to auxiliary, it is valid
    if (from == to || from == 0)
        return 1;

    // If the move is from auxiliary to destination, it is valid
    if (to == 0)
        return 1;

    // If the move is from auxiliary to source and the auxiliary is not already occupied, it is valid
    if (aux == 1 && to!= 0 && to!= 2 * n - 1)
        return 1;

    // If none of the above conditions are met, the move is invalid
    return 0;
}

// Function to solve the tower of Hanoi problem
void towerOfHanoi(int n, char from, char to, char aux)
{
    int i;

    // Base case: move the top disk from source to destination
    if (n == 1) {
        printf("Move disk 1 from %c to %c\n", from, to);
        return;
    }

    // Recursive case: move n-1 disks from source to auxiliary,
    // then move the top disk from source to destination,
    // then move the n-1 disks from auxiliary to destination
    for (i = 0; i < n - 1; i++) {
        if (isValidMove(n, from, to, 3 - from - to)) {
            towerOfHanoi(n - 1, from, aux, to);
            printf("Move disk %d from %c to %c\n", n, from, to);
            break;
        }
    }
}

int main()
{
    int n;
    srand(time(NULL));
    n = rand() % (MAX - 1) + 3;

    printf("Solving the Tower of Hanoi problem with %d disks...\n", n);
    towerOfHanoi(n, 'A', 'C', 'B');

    return 0;
}