//LLAMA2-13B DATASET v1.0 Category: Client Server Application ; Style: irregular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define SERVER_PORT 8888
#define CLIENT_COUNT 5

struct client_data {
    int sock;
    char name[50];
};

int main(void) {
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    struct sockaddr_in server_addr = {
        .sin_family = AF_INET,
        .sin_port = htons(SERVER_PORT),
        .sin_addr.s_addr = INADDR_ANY
    };

    if (bind(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("bind failed");
        exit(1);
    }

    if (listen(sock, 5) < 0) {
        perror("listen failed");
        exit(1);
    }

    printf("Server listening on port %d...\n", SERVER_PORT);

    struct client_data clients[CLIENT_COUNT];
    for (int i = 0; i < CLIENT_COUNT; i++) {
        clients[i].sock = accept(sock, NULL, NULL);
        printf("Client %d connected...\n", i + 1);

        char name[50];
        read(clients[i].sock, name, 50);
        printf("Client %d: %s\n", i + 1, name);

        // Do something with the client...
        // ... like sending a message back to them!
        char message[] = "Hello, client!";
        send(clients[i].sock, message, strlen(message), 0);
    }

    for (int i = 0; i < CLIENT_COUNT; i++) {
        close(clients[i].sock);
    }

    close(sock);
    return 0;
}