//LLAMA2-13B DATASET v1.0 Category: Error handling ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#define MAX_INPUT_SIZE 1024

void handle_error(const char* message) {
    printf("Error: %s\n", message);
    fflush(stdout);
    exit(EXIT_FAILURE);
}

int main() {
    int input_size = 0;
    char* input = NULL;

    // Example 1: NULL pointer error
    if (input == NULL) {
        handle_error("Invalid input");
    }

    // Example 2: Input size too small
    if (input_size < 1) {
        handle_error("Input size too small");
    }

    // Example 3: Input overflow
    if (input_size > MAX_INPUT_SIZE) {
        handle_error("Input overflow");
    }

    // Example 4: Division by zero
    if (10 / 0) {
        handle_error("Division by zero");
    }

    // Example 5: Out-of-range value
    if (input[0] < -100 || input[0] > 100) {
        handle_error("Out-of-range value");
    }

    // Example 6: Logic error
    if (input[0] == 0 && input[1] == 0) {
        handle_error("Logic error");
    }

    // Example 7: NULL pointer dereference
    if (input[0] == NULL) {
        handle_error("NULL pointer dereference");
    }

    return 0;
}