//GPT-4o-mini DATASET v1.0 Category: Classical Circuit Simulator ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>

#define MAX_COMPONENTS 10

typedef enum {
    RESISTOR,
    CAPACITOR,
    VOLTAGE_SOURCE
} ComponentType;

typedef struct {
    ComponentType type;
    char name[20];
    double value; // value for resistance (ohms), capacitance (farads) or voltage (volts)
} Component;

typedef struct {
    Component components[MAX_COMPONENTS];
    int count;
} Circuit;

void addComponent(Circuit *circuit, ComponentType type, const char *name, double value) {
    if (circuit->count < MAX_COMPONENTS) {
        circuit->components[circuit->count].type = type;
        snprintf(circuit->components[circuit->count].name, sizeof(circuit->components[circuit->count].name), "%s", name);
        circuit->components[circuit->count].value = value;
        circuit->count++;
    } else {
        printf("Circuit is full! Cannot add more components.\n");
    }
}

void displayComponents(const Circuit *circuit) {
    printf("Circuit Components:\n");
    for (int i = 0; i < circuit->count; i++) {
        switch (circuit->components[i].type) {
            case RESISTOR:
                printf("Resistor %s: %.2f Ohms\n", circuit->components[i].name, circuit->components[i].value);
                break;
            case CAPACITOR:
                printf("Capacitor %s: %.2f Farads\n", circuit->components[i].name, circuit->components[i].value);
                break;
            case VOLTAGE_SOURCE:
                printf("Voltage Source %s: %.2f Volts\n", circuit->components[i].name, circuit->components[i].value);
                break;
        }
    }
}

double computeTotalResistance(const Circuit *circuit) {
    double totalResistance = 0;
    for (int i = 0; i < circuit->count; i++) {
        if (circuit->components[i].type == RESISTOR) {
            totalResistance += circuit->components[i].value;
        }
    }
    return totalResistance;
}

double computeTotalCapacitance(const Circuit *circuit) {
    double totalCapacitance = 0;
    for (int i = 0; i < circuit->count; i++) {
        if (circuit->components[i].type == CAPACITOR) {
            totalCapacitance += circuit->components[i].value;
        }
    }
    return totalCapacitance;
}

void simulateCircuit(const Circuit *circuit) {
    double totalResistance = computeTotalResistance(circuit);
    double totalCapacitance = computeTotalCapacitance(circuit);

    printf("\nSimulation Results:\n");
    printf("Total Resistance: %.2f Ohms\n", totalResistance);
    printf("Total Capacitance: %.2f Farads\n", totalCapacitance);
}

int main() {
    Circuit myCircuit = { .count = 0 };

    addComponent(&myCircuit, RESISTOR, "R1", 100.0);   // 100 Ohm resistor
    addComponent(&myCircuit, RESISTOR, "R2", 200.0);   // 200 Ohm resistor
    addComponent(&myCircuit, CAPACITOR, "C1", 0.001);  // 1 mF capacitor
    addComponent(&myCircuit, VOLTAGE_SOURCE, "V1", 5.0); // 5 Volt source

    displayComponents(&myCircuit);
    simulateCircuit(&myCircuit);

    return 0;
}