//Falcon-180B DATASET v1.0 Category: Database querying ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

// Function to execute SQL queries and print the results
void execute_query(sqlite3 *db, const char *sql) {
    char *errMsg = NULL;
    int rc;

    rc = sqlite3_exec(db, sql, NULL, NULL, &errMsg);

    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Query executed successfully.\n");
    }
}

// Function to create a table in the database
void create_table(sqlite3 *db) {
    const char *sql = "CREATE TABLE IF NOT EXISTS users (" \
                      "id INTEGER PRIMARY KEY AUTOINCREMENT," \
                      "name TEXT NOT NULL," \
                      "email TEXT NOT NULL UNIQUE);";

    execute_query(db, sql);
}

// Function to insert a user into the database
void insert_user(sqlite3 *db, const char *name, const char *email) {
    char sql[100];
    sprintf(sql, "INSERT INTO users (name, email) VALUES ('%s', '%s');", name, email);

    execute_query(db, sql);
}

// Function to retrieve all users from the database
void get_all_users(sqlite3 *db) {
    const char *sql = "SELECT * FROM users;";

    execute_query(db, sql);
}

// Function to search for a user by email
void search_user_by_email(sqlite3 *db, const char *email) {
    char sql[100];
    sprintf(sql, "SELECT * FROM users WHERE email='%s';", email);

    execute_query(db, sql);
}

int main() {
    sqlite3 *db;
    int rc;

    // Open the database
    rc = sqlite3_open("example.db", &db);

    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    // Create a table
    create_table(db);

    // Insert a user
    insert_user(db, "John Doe", "john.doe@example.com");

    // Get all users
    get_all_users(db);

    // Search for a user by email
    search_user_by_email(db, "john.doe@example.com");

    // Close the database
    sqlite3_close(db);

    return 0;
}