//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: Donald Knuth
/***** DONALD KNUTH STYLE PRODUCT INVENTORY SYSTEM *******/

/* Includes the stdio.h header for standard input and output. */
#include <stdio.h>

/* Defines a structure to represent a product. */
typedef struct product {
    char *name;               /* The name of the product. */
    int quantity;              /* The quantity of the product. */
    double price;              /* The price of the product. */
} product_t;

/* Defines an array of products. */
product_t products[] = {
    { "Apple", 10, 0.50 },
    { "Banana", 5, 0.75 },
    { "Orange", 12, 1.00 },
    { "Grape", 8, 1.25 },
    { "Strawberry", 15, 1.50 }
};

/* Defines the number of products in the array. */
#define NUM_PRODUCTS (sizeof(products) / sizeof(product_t))

/* Defines a function to print the inventory of products. */
void print_inventory() {
    /* Iterates over each product in the array. */
    for (int i = 0; i < NUM_PRODUCTS; i++) {
        /* Prints the name, quantity, and price of the product. */
        printf("%s %d %.2f\n", products[i].name, products[i].quantity, products[i].price);
    }
}

/* Defines a function to add a product to the inventory. */
void add_product(char *name, int quantity, double price) {
    /* Iterates over each product in the array. */
    for (int i = 0; i < NUM_PRODUCTS; i++) {
        /* If the name of the product matches the name of the product being added, 
           then increments the quantity of the product by the quantity being added. */
        if (strcmp(products[i].name, name) == 0) {
            products[i].quantity += quantity;
            return;
        }
    }

    /* If the product is not found in the array, then adds the product to the end 
       of the array. */
    products[NUM_PRODUCTS].name = name;
    products[NUM_PRODUCTS].quantity = quantity;
    products[NUM_PRODUCTS].price = price;
}

/* Defines a function to remove a product from the inventory. */
void remove_product(char *name) {
    /* Iterates over each product in the array. */
    for (int i = 0; i < NUM_PRODUCTS; i++) {
        /* If the name of the product matches the name of the product being removed, 
           then sets the quantity of the product to 0. */
        if (strcmp(products[i].name, name) == 0) {
            products[i].quantity = 0;
            return;
        }
    }
}

/* Defines a function to get the total value of the inventory. */
double get_total_value() {
    /* Initializes the total value to 0. */
    double total_value = 0.0;

    /* Iterates over each product in the array. */
    for (int i = 0; i < NUM_PRODUCTS; i++) {
        /* Adds the product of the quantity and the price of the product to the 
           total value. */
        total_value += products[i].quantity * products[i].price;
    }

    /* Returns the total value. */
    return total_value;
}

/* Defines the main function. */
int main() {
    /* Prints the inventory of products. */
    print_inventory();

    /* Adds a product to the inventory. */
    add_product("Apple", 5, 0.60);

    /* Prints the inventory of products. */
    print_inventory();

    /* Removes a product from the inventory. */
    remove_product("Banana");

    /* Prints the inventory of products. */
    print_inventory();

    /* Gets the total value of the inventory. */
    double total_value = get_total_value();

    /* Prints the total value of the inventory. */
    printf("Total value: %.2f\n", total_value);

    return 0;
}