//Code Llama-13B DATASET v1.0 Category: Text processing ; Style: calm
/*
 * Unique C Text Processing Example Program
 *
 * This program demonstrates a unique approach to text processing in C.
 * It uses a combination of string functions and a custom-defined function
 * to perform various text processing tasks.
 */

#include <stdio.h>
#include <string.h>

// Define a function to count the number of words in a string
int count_words(char *str) {
  int count = 0;
  char *ptr = str;

  while (*ptr != '\0') {
    if (*ptr == ' ') {
      count++;
    }
    ptr++;
  }

  return count + 1;
}

// Define a function to count the number of characters in a string
int count_chars(char *str) {
  int count = 0;
  char *ptr = str;

  while (*ptr != '\0') {
    count++;
    ptr++;
  }

  return count;
}

// Define a function to convert a string to uppercase
void to_uppercase(char *str) {
  char *ptr = str;

  while (*ptr != '\0') {
    if (*ptr >= 'a' && *ptr <= 'z') {
      *ptr = *ptr - 32;
    }
    ptr++;
  }
}

// Define a function to convert a string to lowercase
void to_lowercase(char *str) {
  char *ptr = str;

  while (*ptr != '\0') {
    if (*ptr >= 'A' && *ptr <= 'Z') {
      *ptr = *ptr + 32;
    }
    ptr++;
  }
}

// Define a function to reverse a string
void reverse_string(char *str) {
  char *ptr1 = str;
  char *ptr2 = str;
  char temp;

  while (*ptr1 != '\0') {
    ptr1++;
  }

  ptr1--;

  while (ptr1 >= ptr2) {
    temp = *ptr1;
    *ptr1 = *ptr2;
    *ptr2 = temp;
    ptr1--;
    ptr2++;
  }
}

int main() {
  char str[] = "This is an example string";

  // Print the original string
  printf("Original string: %s\n", str);

  // Count the number of words in the string
  int words = count_words(str);
  printf("Number of words: %d\n", words);

  // Count the number of characters in the string
  int chars = count_chars(str);
  printf("Number of characters: %d\n", chars);

  // Convert the string to uppercase
  to_uppercase(str);
  printf("Uppercase string: %s\n", str);

  // Convert the string to lowercase
  to_lowercase(str);
  printf("Lowercase string: %s\n", str);

  // Reverse the string
  reverse_string(str);
  printf("Reversed string: %s\n", str);

  return 0;
}