//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct Point {
    double x;
    double y;
} Point;

typedef struct Line {
    Point p1;
    Point p2;
} Line;

typedef struct Circle {
    Point center;
    double radius;
} Circle;

// Function to check if a point is inside a circle
int is_inside_circle(Point point, Circle circle) {
    double dx = point.x - circle.center.x;
    double dy = point.y - circle.center.y;
    double distance = sqrt(dx * dx + dy * dy);
    return distance <= circle.radius;
}

// Function to check if a line segment intersects a circle
int does_intersect_circle(Line line, Circle circle) {
    // Check if the line segment intersects the circle's bounding box
    if (line.p1.x < circle.center.x - circle.radius ||
        line.p1.x > circle.center.x + circle.radius ||
        line.p1.y < circle.center.y - circle.radius ||
        line.p1.y > circle.center.y + circle.radius) {
        return 0;
    }

    // Check if the line segment intersects the circle's interior
    if (is_inside_circle(line.p1, circle)) {
        return 1;
    }

    // Check if the line segment intersects the circle's boundary
    double dx = line.p2.x - line.p1.x;
    double dy = line.p2.y - line.p1.y;
    double t = ((circle.center.x - line.p1.x) * dx + (circle.center.y - line.p1.y) * dy) / (dx * dx + dy * dy);
    if (t < 0 || t > 1) {
        return 0;
    }
    Point intersection = {line.p1.x + t * dx, line.p1.y + t * dy};
    return is_inside_circle(intersection, circle);
}

// Function to find the intersection point of a line segment and a circle
Point intersection_point(Line line, Circle circle) {
    double dx = line.p2.x - line.p1.x;
    double dy = line.p2.y - line.p1.y;
    double t = ((circle.center.x - line.p1.x) * dx + (circle.center.y - line.p1.y) * dy) / (dx * dx + dy * dy);
    return (Point){line.p1.x + t * dx, line.p1.y + t * dy};
}

// Function to find the closest point on a line segment to a circle
Point closest_point(Line line, Circle circle) {
    double dx = line.p2.x - line.p1.x;
    double dy = line.p2.y - line.p1.y;
    double t = ((circle.center.x - line.p1.x) * dx + (circle.center.y - line.p1.y) * dy) / (dx * dx + dy * dy);
    if (t < 0) {
        return line.p1;
    } else if (t > 1) {
        return line.p2;
    } else {
        return intersection_point(line, circle);
    }
}

int main() {
    // Define a circle
    Circle circle = {{0, 0}, 5};

    // Define a line segment
    Line line = {{1, 1}, {10, 10}};

    // Check if the line segment intersects the circle
    if (does_intersect_circle(line, circle)) {
        printf("The line segment intersects the circle.\n");

        // Find the intersection point
        Point intersection = intersection_point(line, circle);
        printf("The intersection point is (%.2f, %.2f).\n", intersection.x, intersection.y);

        // Find the closest point on the line segment to the circle
        Point closest = closest_point(line, circle);
        printf("The closest point on the line segment to the circle is (%.2f, %.2f).\n", closest.x, closest.y);
    } else {
        printf("The line segment does not intersect the circle.\n");
    }

    return 0;
}