//LLAMA2-13B DATASET v1.0 Category: Error handling ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#define MAX_LEN 1024

void handleError(const char* message) {
    printf("Oh no! %s\n", message);
    if (message[0] == 'E') {
        printf("It seems we have an E-xistential crisis on our hands...\n");
    } else if (message[0] == 'A') {
        printf("Apparently, we have an A-ternal problem...\n");
    } else {
        printf("Uh oh, it looks like we have a %c-shaped issue...\n", message[0]);
    }
    exit(EXIT_FAILURE);
}

int main() {
    char buffer[MAX_LEN];
    int ret = 0;

    // Try to allocate an array with a negative size
    ret = malloc(-1 * sizeof(int));
    if (ret == NULL) {
        handleError("Out of space?!");
    }

    // Try to access an invalid pointer
    ret = *(int*)0xbadcafebabe;
    if (ret == 0) {
        handleError("Oops, we have a pointer to nowhere...");
    }

    // Try to strcpy a string that is too long
    char longString[] = "This string is too long to be copied...";
    ret = strcpy(buffer, longString);
    if (ret == 0) {
        handleError("String too long! Time to break out the nanite-infused bubble wrap...");
    }

    // Try to access an array out of bounds
    int arr[5] = {1, 2, 3, 4, 5};
    ret = arr[6];
    if (ret == 0) {
        handleError("Whoa, we're in the twilight zone...");
    }

    return 0;
}