//GEMINI-pro DATASET v1.0 Category: Warehouse Management System ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_NAME_LENGTH 50

typedef struct Item {
    char name[MAX_NAME_LENGTH];
    int quantity;
    float price;
} Item;

Item warehouse[MAX_ITEMS];
int num_items = 0;

void add_item(char *name, int quantity, float price) {
    if (num_items == MAX_ITEMS) {
        printf("ERROR: Warehouse is full!\n");
        return;
    }

    strcpy(warehouse[num_items].name, name);
    warehouse[num_items].quantity = quantity;
    warehouse[num_items].price = price;

    num_items++;
}

void remove_item(char *name) {
    int i;

    for (i = 0; i < num_items; i++) {
        if (strcmp(warehouse[i].name, name) == 0) {
            break;
        }
    }

    if (i == num_items) {
        printf("ERROR: Item not found!\n");
        return;
    }

    for (i; i < num_items - 1; i++) {
        warehouse[i] = warehouse[i + 1];
    }

    num_items--;
}

void print_inventory() {
    int i;

    printf("Inventory:\n");
    printf("--------------------------------------------------------------------------------\n");
    printf("| %-20s | %-10s | %-10s |\n", "Name", "Quantity", "Price");
    printf("--------------------------------------------------------------------------------\n");
    for (i = 0; i < num_items; i++) {
        printf("| %-20s | %-10d | %-10.2f |\n", warehouse[i].name, warehouse[i].quantity, warehouse[i].price);
    }
    printf("--------------------------------------------------------------------------------\n");
}

int main() {
    add_item("Apples", 10, 1.00);
    add_item("Bananas", 15, 1.50);
    add_item("Oranges", 20, 2.00);

    print_inventory();

    remove_item("Bananas");

    print_inventory();

    return 0;
}