//Code Llama-13B DATASET v1.0 Category: Tic Tac Toe AI ; Style: medieval
/*
 * Medieval Tic Tac Toe AI
 *
 * This program plays a game of Tic Tac Toe against a human player, using a simple
 * AI algorithm. The AI will always choose to play in the center square, if
 * possible. If the center square is already taken, it will choose to play in
 * a corner square. If all squares are taken, the AI will choose to play in a
 * random square.
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define BOARD_SIZE 3
#define CENTER_SQUARE 5
#define CORNER_SQUARE 9

// Define the possible moves for the player and the AI
enum Move {
    X,
    O,
    EMPTY
};

// Define the board
enum Move board[BOARD_SIZE][BOARD_SIZE] = {
    {EMPTY, EMPTY, EMPTY},
    {EMPTY, EMPTY, EMPTY},
    {EMPTY, EMPTY, EMPTY}
};

// Define the player and AI moves
enum Move player_move;
enum Move ai_move;

// Define the winner
enum Move winner;

// Print the board
void print_board() {
    printf("\n");
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            switch (board[i][j]) {
                case X:
                    printf("X");
                    break;
                case O:
                    printf("O");
                    break;
                case EMPTY:
                    printf(" ");
                    break;
            }
        }
        printf("\n");
    }
}

// Check if the game is over
void check_game_over() {
    // Check rows
    for (int i = 0; i < BOARD_SIZE; i++) {
        if (board[i][0] == board[i][1] && board[i][1] == board[i][2]) {
            winner = board[i][0];
            return;
        }
    }

    // Check columns
    for (int j = 0; j < BOARD_SIZE; j++) {
        if (board[0][j] == board[1][j] && board[1][j] == board[2][j]) {
            winner = board[0][j];
            return;
        }
    }

    // Check diagonals
    if (board[0][0] == board[1][1] && board[1][1] == board[2][2]) {
        winner = board[0][0];
        return;
    }
    if (board[0][2] == board[1][1] && board[1][1] == board[2][0]) {
        winner = board[0][2];
        return;
    }

    // Check if all squares are taken
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            if (board[i][j] == EMPTY) {
                return;
            }
        }
    }

    // If all squares are taken and no winner was found, it's a tie
    winner = EMPTY;
}

// Make a move
void make_move(enum Move player) {
    int row, col;
    printf("Enter a row and column (1-3): ");
    scanf("%d %d", &row, &col);

    if (board[row - 1][col - 1] == EMPTY) {
        board[row - 1][col - 1] = player;
    } else {
        printf("Square already taken. Try again.\n");
        make_move(player);
    }
}

// Get the AI move
void get_ai_move() {
    // If the center square is empty, play in the center
    if (board[1][1] == EMPTY) {
        ai_move = CENTER_SQUARE;
    }
    // If the center square is taken, play in a corner
    else {
        ai_move = CORNER_SQUARE;
    }
}

int main() {
    srand(time(NULL));

    // Print the board
    print_board();

    // Loop until the game is over
    while (winner == EMPTY) {
        // Player makes a move
        make_move(X);

        // Print the board
        print_board();

        // Check if the game is over
        check_game_over();

        // If the game is not over, the AI makes a move
        if (winner == EMPTY) {
            get_ai_move();

            // Print the board
            print_board();

            // Check if the game is over
            check_game_over();
        }
    }

    // Print the winner
    if (winner == X) {
        printf("Player X wins!\n");
    } else if (winner == O) {
        printf("Player O wins!\n");
    } else {
        printf("It's a tie!\n");
    }

    return 0;
}