//GEMINI-pro DATASET v1.0 Category: Website Uptime Monitor ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <curl/curl.h>

// Function to check the uptime of a website
char* check_uptime(char *url) {
    time_t start, end;
    CURL *curl;
    CURLcode res;
    double time_taken;
    char *uptime;

    // Initialize the CURL object
    curl = curl_easy_init();
    if (curl == NULL) {
        return "Error initializing CURL";
    }

    // Set the URL to check
    curl_easy_setopt(curl, CURLOPT_URL, url);

    // Set the timeout to 10 seconds
    curl_easy_setopt(curl, CURLOPT_TIMEOUT, 10);

    // Set the follow location option to true
    curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, 1);

    // Set the user agent
    curl_easy_setopt(curl, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.93 Safari/537.36");

    // Perform the request
    start = time(NULL);
    res = curl_easy_perform(curl);
    end = time(NULL);
    time_taken = difftime(end, start);

    // Check the response code
    if (res != CURLE_OK) {
        return "Error performing request";
    }

    // Get the uptime from the response body
    char *body;
    size_t body_len;
    curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &res);
    if (res == 200) {
        curl_easy_getinfo(curl, CURLINFO_CONTENT_TYPE, &body);
        body_len = strlen(body);
        uptime = malloc(body_len + 1);
        strcpy(uptime, body);
    } else {
        return "Error getting response body";
    }

    // Cleanup the CURL object
    curl_easy_cleanup(curl);

    // Return the uptime
    return uptime;
}

// Main function
int main(int argc, char **argv) {
    // Check the number of arguments
    if (argc < 2) {
        printf("Usage: %s <url>\n", argv[0]);
        return 1;
    }

    // Get the URL from the command line
    char *url = argv[1];

    // Check the uptime of the website
    char *uptime = check_uptime(url);

    // Print the uptime
    printf("Uptime: %s\n", uptime);

    // Free the memory allocated for the uptime
    free(uptime);

    return 0;
}