//MISTRAL-7B DATASET v1.0 Category: Alien Language Translator ; Style: real-life
#include <stdio.h>
#include <string.h>

#define TABLE_SIZE 256

// Alien struct
typedef struct {
    char name[20];
    int height_cm;
    int weight_kg;
} Alien;

// English to Alien lookup table
const char lookup_table[TABLE_SIZE] = "XqjKlMbPwRtSdEfGhIuZvTgYnAxOcV";

// Function to translate English text into Alien language
char *translate_english_to_alien(const char *english_text) {
    char *alien_text = malloc(strlen(english_text) * sizeof(char));

    for (int i = 0; i < strlen(english_text); i++) {
        alien_text[i] = lookup_table[english_text[i]];
    }

    return alien_text;
}

// Function to print Alien's name and greet them in their language
void greet_alien(const Alien *alien) {
    char *greeting = malloc(sizeof(char) * 20);
    strcpy(greeting, "Grqgx grqgxq "); // Alien greeting

    printf("Greeting %s, the %d cm tall, %d kg heavy Alien:\n", alien->name, alien->height_cm, alien->weight_kg);
    printf("%s\n", translate_english_to_alien(greeting));
    free(greeting);
}

int main() {
    Alien alien = {"Zorgon", 120, 80};
    char *english_text = "Hello Alien!";

    // Translate English text into Alien language
    char *alien_text = translate_english_to_alien(english_text);

    // Print greeting for the Alien
    greet_alien(&alien);

    // Free memory
    free(alien_text);

    return 0;
}