//GEMINI-pro DATASET v1.0 Category: Port Scanner ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define MAX_PORTS 100

int main(int argc, char *argv[]) {
  // Cyberpunk-themed banner
  printf("===================================================================\n");
  printf("░██████╗░░█████╗░███╗░░██╗██╗░░██╗██╗░░██╗░█████╗░███╗░░██╗\n");
  printf("██╔════╝░██╔══██╗████╗░██║██║░██╔╝██║░██╔╝██╔══██╗████╗░██║\n");
  printf("██║  ███╗██║░░██║██╔██╗██║█████═╝░███████║███████║██╔██╗██║\n");
  printf("██║   ██║██║░░██║██║╚████║██╔═██╗░██╔══██║██╔══██║██║╚████║\n");
  printf("╚██████╔╝╚█████╔╝██║░╚███║██║░╚██╗██║░░██║██║░░██║██║░╚███║\n");
  printf("░╚═════╝░░╚════╝░╚═╝░░╚══╝╚═╝░░╚═╝╚═╝░░╚═╝╚═╝░░╚═╝╚═╝░░╚══╝\n");
  printf("===================================================================\n");

  // Check if the user provided an IP address
  if (argc < 2) {
    fprintf(stderr, "Usage: %s <IP address>\n", argv[0]);
    exit(EXIT_FAILURE);
  }

  // Get the IP address from the command line
  char *ip_address = argv[1];

  // Create a socket
  int sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0) {
    perror("socket");
    exit(EXIT_FAILURE);
  }

  // Set the socket options
  int optval = 1;
  if (setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, &optval, sizeof(optval)) < 0) {
    perror("setsockopt");
    exit(EXIT_FAILURE);
  }

  // Resolve the IP address
  struct sockaddr_in serv_addr;
  memset(&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons(0);
  if (inet_pton(AF_INET, ip_address, &serv_addr.sin_addr) <= 0) {
    perror("inet_pton");
    exit(EXIT_FAILURE);
  }

  // Scan the ports
  int ports[MAX_PORTS];
  for (int i = 0; i < MAX_PORTS; i++) {
    ports[i] = i + 1;
  }

  for (int i = 0; i < MAX_PORTS; i++) {
    serv_addr.sin_port = htons(ports[i]);

    // Connect to the port
    if (connect(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) == 0) {
      printf("Port %d: open\n", ports[i]);
    } else {
      printf("Port %d: closed\n", ports[i]);
    }
  }

  // Close the socket
  close(sockfd);

  return 0;
}