//Falcon2-11B DATASET v1.0 Category: Network Packet Monitoring ; Style: active
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/ip.h>

#define MAX_PACKETS 100

void monitor_packets(int sock) {
    char packet[65535];
    int nread;
    struct sockaddr_in peer;
    socklen_t peer_len = sizeof(peer);

    for (int i = 0; i < MAX_PACKETS; i++) {
        printf("Waiting for incoming packet...\n");
        nread = recvfrom(sock, packet, sizeof(packet), 0, (struct sockaddr *) &peer, &peer_len);
        if (nread < 0) {
            perror("recvfrom");
            continue;
        }
        printf("Received packet: %s\n", packet);
        // Do something with the packet here
    }
}

int main() {
    int sock;
    struct sockaddr_in server;
    socklen_t server_len = sizeof(server);

    sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (sock < 0) {
        perror("socket");
        exit(1);
    }

    server.sin_family = AF_INET;
    server.sin_port = htons(12345);
    server.sin_addr.s_addr = INADDR_ANY;

    if (bind(sock, (struct sockaddr *) &server, server_len) < 0) {
        perror("bind");
        exit(1);
    }

    monitor_packets(sock);

    close(sock);
    return 0;
}