//Falcon-180B DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

typedef struct {
    int flightNumber;
    int destination;
    int baggageCount;
} Flight;

typedef struct {
    int id;
    int destination;
} Baggage;

void generateFlights(Flight* flights, int count) {
    for (int i = 0; i < count; i++) {
        flights[i].flightNumber = rand() % 1000 + 1;
        flights[i].destination = rand() % 10 + 1;
        flights[i].baggageCount = rand() % 50 + 1;
    }
}

void generateBaggage(Baggage* baggage, int count) {
    for (int i = 0; i < count; i++) {
        baggage[i].id = i + 1;
        baggage[i].destination = rand() % 10 + 1;
    }
}

void printFlight(Flight flight) {
    printf("Flight Number: %d\n", flight.flightNumber);
    printf("Destination: %d\n", flight.destination);
    printf("Baggage Count: %d\n", flight.baggageCount);
}

void printBaggage(Baggage baggage) {
    printf("ID: %d\n", baggage.id);
    printf("Destination: %d\n", baggage.destination);
}

int main() {
    srand(time(NULL));

    int flightsCount = 5;
    Flight flights[flightsCount];
    generateFlights(flights, flightsCount);

    int baggageCount = 20;
    Baggage baggage[baggageCount];
    generateBaggage(baggage, baggageCount);

    printf("Flight Schedule:\n");
    for (int i = 0; i < flightsCount; i++) {
        printFlight(flights[i]);
    }

    printf("\nBaggage Handling:\n");
    for (int i = 0; i < baggageCount; i++) {
        int flightNumber = baggage[i].destination;
        Flight* flight = NULL;
        for (int j = 0; j < flightsCount; j++) {
            if (flights[j].destination == flightNumber) {
                flight = &flights[j];
                break;
            }
        }
        if (flight!= NULL) {
            printf("Baggage %d assigned to Flight %d\n", baggage[i].id, flight->flightNumber);
        } else {
            printf("Baggage %d not assigned\n", baggage[i].id);
        }
    }

    return 0;
}