//GPT-4o-mini DATASET v1.0 Category: Ebook reader ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <stdbool.h>

#define MAX_BOOKS 100
#define MAX_CONTENT 1024
#define MAX_TITLE 100

typedef struct {
    char title[MAX_TITLE];
    char content[MAX_CONTENT];
} Book;

typedef struct {
    Book books[MAX_BOOKS];
    int count;
    pthread_mutex_t lock;
} Library;

Library library;

void* load_books(void* arg) {
    pthread_mutex_lock(&library.lock);
    for (int i = 0; i < 3; i++) {
        snprintf(library.books[i].title, sizeof(library.books[i].title), "Book %d", i + 1);
        snprintf(library.books[i].content, sizeof(library.books[i].content), "This is the content of Book %d", i + 1);
    }
    library.count = 3;
    pthread_mutex_unlock(&library.lock);
    return NULL;
}

void* display_books(void* arg) {
    pthread_mutex_lock(&library.lock);
    printf("Available Books:\n");
    for (int i = 0; i < library.count; i++) {
        printf("%d. %s\n", i + 1, library.books[i].title);
    }
    pthread_mutex_unlock(&library.lock);
    return NULL;
}

void* read_book(void* arg) {
    int index = *(int*)arg;
    pthread_mutex_lock(&library.lock);
    
    if (index < 0 || index >= library.count) {
        printf("Invalid book index!\n");
    } else {
        printf("Reading %s:\n%s\n", library.books[index].title, library.books[index].content);
    }
    
    pthread_mutex_unlock(&library.lock);
    return NULL;
}

int main() {
    pthread_t loader_thread, display_thread[2], reader_thread[2];
    int book_indices[2] = {0, 1};

    library.count = 0;
    pthread_mutex_init(&library.lock, NULL);

    // Load books
    pthread_create(&loader_thread, NULL, load_books, NULL);
    pthread_join(loader_thread, NULL);
    
    // Display books
    pthread_create(&display_thread[0], NULL, display_books, NULL);
    pthread_create(&display_thread[1], NULL, display_books, NULL);
    
    pthread_join(display_thread[0], NULL);
    pthread_join(display_thread[1], NULL);

    // Read specific books
    pthread_create(&reader_thread[0], NULL, read_book, &book_indices[0]);
    pthread_create(&reader_thread[1], NULL, read_book, &book_indices[1]);
    
    pthread_join(reader_thread[0], NULL);
    pthread_join(reader_thread[1], NULL);

    // Final cleanup
    pthread_mutex_destroy(&library.lock);
    
    return 0;
}