//GEMINI-pro DATASET v1.0 Category: Temperature monitor ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <inttypes.h>
#include <stdbool.h>
#include <stddef.h>
#include <time.h>

typedef uint64_t u64;
typedef int64_t i64;

#define MEMB_ZERO(x) memset((x), 0, sizeof(x))
#define MEMB_COPY(d, s) memcpy((d), (s), sizeof(s))
#define MEMB_ALIGN(x, align) (((((x)+(align)-1))&(~~((align)-1)))

#define TEMP_SENSOR_COUNT 3

struct {
    i64 temperature;
    u64 timestamp;
} temperature_readings_backup[TEMP_SENSOR_COUNT];

static const char *temperature_sensor_names[TEMP_SENSOR_COUNT] = {
    "Temperature Sensor 1",
    "Temperature Sensor 2",
    "Temperature Sensor 3"
};

static const char *temperature_alert_levels[3] = {
    "NORMAL",
    "WARNING",
    "CRITICAL"
};

void handle_temperature_reading(i64 temperature, u64 timestamp, int temperature_sensor_index) {

    // Check if the temperature reading is within the expected range.

    if (temperature < -127 || temperature > 127) {

        // The temperature reading is out of range. Print an error message and exit.

        fprintf(stderr, "Error: Temperature reading out of range: %"PRId64"\n", temperature);
        exit(EXIT_FAILURE);
    }

    // Check if the temperature reading has changed significantly since the last reading.

    i64 temperature_delta = llabs(temperature - temperature_readings_backup[temperature_sensor_index].temperature);

    if (temperature_delta > 10000000000LL || temperature_delta == 0LL) {

        // The temperature reading has changed significantly or has not changed at all. Print an error message and exit.

        fprintf(stderr, "Error: Temperature reading changed significantly or has not changed at all: %"PRId64"\n", temperature_delta);
        exit(EXIT_FAILURE);
    }

    // Update the temperature reading backup.

    temperature_readings_backup[temperature_sensor_index].temperature = temperature;
    temperature_readings_backup[temperature_sensor_index].timestamp = timestamp;

    // Determine the temperature alert level.

    int temperature_alert_level;

    if (temperature < 0) {
        temperature_alert_level = 0;
    } else if (temperature < 30) {
        temperature_alert_level = 1;
    } else {
        temperature_alert_level = 2;
    }

    // Print the temperature reading and the temperature alert level.

    printf("Temperature reading from %s: %"PRId64" (timestamp: %"PRIu64") - Temperature Alert Level: %s\n",
        temperature_sensor_names[temperature_sensor_index], temperature, timestamp, temperature_alert_levels[temperature_alert_level]);

    // If the temperature alert level is CRITICAL, send an alert email.

    if (temperature_alert_level == 2) {
        // Send an alert email.
    }
}

int main(int argc, char **argv) {

    // Initialize the temperature readings backup.

    for (int i = 0; i < TEMP_SENSOR_COUNT; i++) {
        temperature_readings_backup[i].temperature = -128;
    }

    // Get the current time.

    u64 current_time = time(NULL);

    // Get the temperature readings from the temperature sensors.

    for (int i = 0; i < TEMP_SENSOR_COUNT; i++) {
        i64 temperature;

        // Get the temperature reading from the temperature sensor.

        // ...

        // Handle the temperature reading.

        handle_temperature_reading(temperature, current_time, i);
    }

    return EXIT_SUCCESS;
}