//Code Llama-13B DATASET v1.0 Category: Appointment Scheduler ; Style: random
/*
* appointment_scheduler.c
*
* A unique C Appointment Scheduler example program in a random style
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_APPOINTMENTS 10

typedef struct {
    char name[32];
    int day;
    int month;
    int year;
    int hour;
    int minute;
} Appointment;

void schedule_appointment(Appointment* appointment, const char* name, int day, int month, int year, int hour, int minute) {
    strcpy(appointment->name, name);
    appointment->day = day;
    appointment->month = month;
    appointment->year = year;
    appointment->hour = hour;
    appointment->minute = minute;
}

void print_appointment(const Appointment* appointment) {
    printf("%s on %d/%d/%d at %d:%d\n", appointment->name, appointment->day, appointment->month, appointment->year, appointment->hour, appointment->minute);
}

int main() {
    Appointment appointments[MAX_APPOINTMENTS];
    int num_appointments = 0;

    // Schedule an appointment
    schedule_appointment(&appointments[num_appointments], "John", 10, 12, 2023, 10, 30);
    num_appointments++;

    // Schedule another appointment
    schedule_appointment(&appointments[num_appointments], "Jane", 15, 12, 2023, 14, 00);
    num_appointments++;

    // Print all appointments
    for (int i = 0; i < num_appointments; i++) {
        print_appointment(&appointments[i]);
    }

    return 0;
}