//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 1000

typedef struct {
    char name[50];
    int votes;
} candidate;

typedef struct {
    char name[50];
    int voter_id;
    int voted;
} voter;

candidate candidates[MAX_CANDIDATES];
voter voters[MAX_VOTERS];

int num_candidates = 0;
int num_voters = 0;

void add_candidate(char* name) {
    if (num_candidates >= MAX_CANDIDATES) {
        printf("Error: maximum number of candidates reached\n");
        return;
    }
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(char* name, int voter_id) {
    if (num_voters >= MAX_VOTERS) {
        printf("Error: maximum number of voters reached\n");
        return;
    }
    strcpy(voters[num_voters].name, name);
    voters[num_voters].voter_id = voter_id;
    voters[num_voters].voted = 0;
    num_voters++;
}

void vote(int voter_id, int candidate_index) {
    for (int i = 0; i < num_voters; i++) {
        if (voters[i].voter_id == voter_id &&!voters[i].voted) {
            candidates[candidate_index].votes++;
            voters[i].voted = 1;
            break;
        }
    }
}

void print_results() {
    printf("\nResults:\n");
    for (int i = 0; i < num_candidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    add_candidate("Alice");
    add_candidate("Bob");
    add_candidate("Charlie");

    add_voter("John", 1);
    add_voter("Jane", 2);
    add_voter("Jim", 3);

    vote(1, 0);
    vote(2, 1);
    vote(3, 2);

    print_results();

    return 0;
}