//GPT-4o-mini DATASET v1.0 Category: Task Scheduler ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>
#include <stdbool.h>

#define MAX_TASKS 10
#define TASK_EXECUTION_TIME 5

typedef void (*TaskFunction)(void);

typedef struct {
    int id;
    int delay;
    TaskFunction function;
} Task;

typedef struct {
    Task tasks[MAX_TASKS];
    int count;
    pthread_mutex_t mutex;
} TaskScheduler;

void exampleTask1() {
    printf("Task 1 is running...\n");
    sleep(TASK_EXECUTION_TIME);
    printf("Task 1 completed.\n");
}

void exampleTask2() {
    printf("Task 2 is running...\n");
    sleep(TASK_EXECUTION_TIME);
    printf("Task 2 completed.\n");
}

void exampleTask3() {
    printf("Task 3 is running...\n");
    sleep(TASK_EXECUTION_TIME);
    printf("Task 3 completed.\n");
}

void* executeTask(void* arg) {
    Task* task = (Task*)arg;
    sleep(task->delay);
    task->function();
    return NULL;
}

void addTask(TaskScheduler* scheduler, int delay, TaskFunction function) {
    if (scheduler->count < MAX_TASKS) {
        pthread_mutex_lock(&scheduler->mutex);
        scheduler->tasks[scheduler->count].id = scheduler->count;
        scheduler->tasks[scheduler->count].delay = delay;
        scheduler->tasks[scheduler->count].function = function;
        scheduler->count++;
        pthread_mutex_unlock(&scheduler->mutex);
    } else {
        printf("Cannot add more tasks. Maximum limit reached.\n");
    }
}

void scheduleTasks(TaskScheduler* scheduler) {
    pthread_t threads[MAX_TASKS];
    for (int i = 0; i < scheduler->count; i++) {
        pthread_create(&threads[i], NULL, executeTask, (void*)&scheduler->tasks[i]);
    }
    for (int i = 0; i < scheduler->count; i++) {
        pthread_join(threads[i], NULL);
    }
}

int main() {
    TaskScheduler scheduler;
    scheduler.count = 0;
    pthread_mutex_init(&scheduler.mutex, NULL);

    // Adding tasks to the scheduler
    addTask(&scheduler, 1, exampleTask1);
    addTask(&scheduler, 2, exampleTask2);
    addTask(&scheduler, 3, exampleTask3);

    printf("Starting task scheduler...\n");
    scheduleTasks(&scheduler);
    
    pthread_mutex_destroy(&scheduler.mutex);
    return 0;
}