//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[50];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void addItem(Item item) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            items[i] = item;
            return;
        }
    }
    printf("Error: Item list is full.\n");
}

void displayItems() {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            printf("%s - %d - %.2f\n", items[i].name, items[i].quantity, items[i].price);
        }
    }
}

int calculateTotal(int items_count) {
    int total = 0;
    for (int i = 0; i < items_count; i++) {
        total += items[i].quantity * items[i].price;
    }
    return total;
}

void generateBill(int items_count) {
    printf("Romeo & Juliet Coffee Shop\n");
    printf("------------------------\n");
    printf("Items:\n");
    displayItems();
    printf("\nTotal Cost: $%d\n", calculateTotal(items_count));
    printf("Thank you for your visit!\n");
}

int main() {
    Item item1 = {"Cappuccino", 2, 3.50};
    addItem(item1);

    Item item2 = {"Latte", 1, 2.00};
    addItem(item2);

    Item item3 = {"Americano", 0, 1.50};
    addItem(item3);

    generateBill(3);

    return 0;
}