//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

// Define the port number.
#define PORT 8080

// Define the maximum size of the buffer.
#define MAX_BUFFER_SIZE 1024

// Main function.
int main() {
  // Create a socket.
  int sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd == -1) {
    perror("socket");
    return EXIT_FAILURE;
  }

  // Bind the socket to the port.
  struct sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family = AF_INET;
  servaddr.sin_addr.s_addr = INADDR_ANY;
  servaddr.sin_port = htons(PORT);
  if (bind(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) == -1) {
    perror("bind");
    return EXIT_FAILURE;
  }

  // Listen for connections.
  if (listen(sockfd, 5) == -1) {
    perror("listen");
    return EXIT_FAILURE;
  }

  // Accept a connection.
  int connfd = accept(sockfd, (struct sockaddr *)NULL, NULL);
  if (connfd == -1) {
    perror("accept");
    return EXIT_FAILURE;
  }

  // Read the message from the client.
  char buffer[MAX_BUFFER_SIZE];
  memset(buffer, 0, sizeof(buffer));
  if (read(connfd, buffer, sizeof(buffer)) == -1) {
    perror("read");
    return EXIT_FAILURE;
  }

  // Print the message from the client.
  printf("Message from client: %s\n", buffer);

  // Write a message to the client.
  char *message = "Hello from server!";
  if (write(connfd, message, strlen(message)) == -1) {
    perror("write");
    return EXIT_FAILURE;
  }

  // Close the connection.
  close(connfd);

  // Close the socket.
  close(sockfd);

  return EXIT_SUCCESS;
}