//GPT-4o-mini DATASET v1.0 Category: Bitwise operations ; Style: Dennis Ritchie
#include <stdio.h>

// Function to set a bit at a specific position
unsigned int setBit(unsigned int num, int pos) {
    return num | (1 << pos);
}

// Function to clear a bit at a specific position
unsigned int clearBit(unsigned int num, int pos) {
    return num & ~(1 << pos);
}

// Function to toggle a bit at a specific position
unsigned int toggleBit(unsigned int num, int pos) {
    return num ^ (1 << pos);
}

// Function to check if a bit at a specific position is set
int isBitSet(unsigned int num, int pos) {
    return (num & (1 << pos)) != 0;
}

// Function to count the number of set bits
int countSetBits(unsigned int num) {
    int count = 0;
    while (num) {
        count += num & 1; // Increment count if the least significant bit is set
        num >>= 1; // Right shift num to check next bit
    }
    return count;
}

// Function to display the binary representation of a number
void printBinary(unsigned int num) {
    for (int i = (sizeof(num) * 8 - 1); i >= 0; i--) {
        printf("%d", (num >> i) & 1);
    }
    printf(" (binary)\n");
}

// Main function to demonstrate bitwise operations
int main() {
    unsigned int num = 29; // Example number: 29
    int pos;

    printf("Original number: %u\n", num);
    printf("Binary representation: ");
    printBinary(num);

    // Setting a bit
    pos = 1; // Set the 1st bit
    num = setBit(num, pos);
    printf("After setting bit at position %d: %u\n", pos, num);
    printBinary(num);

    // Clearing a bit
    pos = 3; // Clear the 3rd bit
    num = clearBit(num, pos);
    printf("After clearing bit at position %d: %u\n", pos, num);
    printBinary(num);

    // Toggling a bit
    pos = 2; // Toggle the 2nd bit
    num = toggleBit(num, pos);
    printf("After toggling bit at position %d: %u\n", pos, num);
    printBinary(num);

    // Checking if a bit is set
    pos = 4; // Check if the 4th bit is set
    if (isBitSet(num, pos)) {
        printf("Bit at position %d is set.\n", pos);
    } else {
        printf("Bit at position %d is not set.\n", pos);
    }

    // Count set bits
    int setBitsCount = countSetBits(num);
    printf("Number of set bits: %d\n", setBitsCount);

    // Demonstration of multiple operations
    unsigned int num2 = 15; // Another number for demonstration
    printf("\nUsing another number: %u\n", num2);
    printf("Binary representation: ");
    printBinary(num2);

    // Performing a series of operations
    num2 = setBit(num2, 4);
    printf("Set bit at position 4: %u\n", num2);
    printBinary(num2);

    num2 = clearBit(num2, 0);
    printf("Cleared bit at position 0: %u\n", num2);
    printBinary(num2);

    num2 = toggleBit(num2, 2);
    printf("Toggled bit at position 2: %u\n", num2);
    printBinary(num2);

    // Check for bit for another position
    pos = 3; // Check if 3rd bit is set
    printf("Checking if bit at position %d is set: ", pos);
    if (isBitSet(num2, pos)) {
        printf("Yes, it's set.\n");
    } else {
        printf("No, it's not set.\n");
    }

    // Count set bits in the second number
    setBitsCount = countSetBits(num2);
    printf("Total set bits in %u: %d\n", num2, setBitsCount);

    return 0;
}