//Falcon2-11B DATASET v1.0 Category: Product Inventory System ; Style: complex
#include <stdio.h>
#include <stdlib.h>

// Define the structure for a product
struct Product {
    char name[50];
    int quantity;
    float price;
};

// Function to add a product to the inventory
void addProduct(struct Product* products, int numProducts, struct Product newProduct) {
    // Check if the product already exists in the inventory
    for (int i = 0; i < numProducts; i++) {
        if (strcmp(products[i].name, newProduct.name) == 0) {
            // If the product already exists, update its quantity
            products[i].quantity += newProduct.quantity;
            return;
        }
    }
    
    // If the product does not exist, add it to the inventory
    products[numProducts] = newProduct;
    numProducts++;
}

// Function to remove a product from the inventory
void removeProduct(struct Product* products, int numProducts, char* name) {
    // Find the product to remove
    for (int i = 0; i < numProducts; i++) {
        if (strcmp(products[i].name, name) == 0) {
            // Remove the product from the inventory
            for (int j = i; j < numProducts - 1; j++) {
                products[j] = products[j + 1];
            }
            numProducts--;
            return;
        }
    }
    
    // If the product does not exist, print an error message
    printf("Product not found in inventory\n");
}

// Function to display the inventory
void displayInventory(struct Product* products, int numProducts) {
    // Display the product name, quantity, and price
    for (int i = 0; i < numProducts; i++) {
        printf("Product: %s\n", products[i].name);
        printf("Quantity: %d\n", products[i].quantity);
        printf("Price: $%.2f\n", products[i].price);
        printf("\n");
    }
}

// Main function
int main() {
    // Create an array to hold the products in the inventory
    struct Product products[100];
    
    // Initialize the number of products in the inventory
    int numProducts = 0;
    
    // Create a new product and add it to the inventory
    struct Product newProduct;
    strcpy(newProduct.name, "Product 1");
    newProduct.quantity = 10;
    newProduct.price = 5.99;
    addProduct(products, numProducts, newProduct);
    
    // Display the inventory
    displayInventory(products, numProducts);
    
    // Remove the product from the inventory
    removeProduct(products, numProducts, "Product 1");
    
    // Display the updated inventory
    displayInventory(products, numProducts);
    
    // Clean up and return
    return 0;
}