//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

// Define the message structure
struct msgbuf {
    long mtype;
    char mtext[256];
};

// Define the message queues
#define ROMEO_QUEUE_ID 12345
#define JULIET_QUEUE_ID 67890

int main() {
    // Create the Romeo and Juliet message queues
    int romeo_queue_id = msgget(ROMEO_QUEUE_ID, IPC_CREAT | 0666);
    if (romeo_queue_id == -1) {
        perror("msgget");
        exit(EXIT_FAILURE);
    }

    int juliet_queue_id = msgget(JULIET_QUEUE_ID, IPC_CREAT | 0666);
    if (juliet_queue_id == -1) {
        perror("msgget");
        exit(EXIT_FAILURE);
    }

    // Create the Romeo and Juliet processes
    pid_t romeo_pid = fork();
    if (romeo_pid == -1) {
        perror("fork");
        exit(EXIT_FAILURE);
    }

    pid_t juliet_pid = fork();
    if (juliet_pid == -1) {
        perror("fork");
        exit(EXIT_FAILURE);
    }

    // Romeo process
    if (romeo_pid == 0) {
        // Send a message to Juliet
        struct msgbuf romeo_msg = {
            .mtype = 1,
            .mtext = "My dearest Juliet, I love thee!"
        };

        if (msgsnd(juliet_queue_id, &romeo_msg, sizeof(romeo_msg.mtext), 0) == -1) {
            perror("msgsnd");
            exit(EXIT_FAILURE);
        }

        // Receive a message from Juliet
        struct msgbuf juliet_msg;
        if (msgrcv(romeo_queue_id, &juliet_msg, sizeof(juliet_msg.mtext), 2, 0) == -1) {
            perror("msgrcv");
            exit(EXIT_FAILURE);
        }

        // Print Juliet's message
        printf("Romeo: %s\n", juliet_msg.mtext);
    }

    // Juliet process
    else if (juliet_pid == 0) {
        // Receive a message from Romeo
        struct msgbuf romeo_msg;
        if (msgrcv(juliet_queue_id, &romeo_msg, sizeof(romeo_msg.mtext), 1, 0) == -1) {
            perror("msgrcv");
            exit(EXIT_FAILURE);
        }

        // Print Romeo's message
        printf("Juliet: %s\n", romeo_msg.mtext);

        // Send a message to Romeo
        struct msgbuf juliet_msg = {
            .mtype = 2,
            .mtext = "My dearest Romeo, I love thee too!"
        };

        if (msgsnd(romeo_queue_id, &juliet_msg, sizeof(juliet_msg.mtext), 0) == -1) {
            perror("msgsnd");
            exit(EXIT_FAILURE);
        }
    }

    // Parent process
    else {
        // Wait for the Romeo and Juliet processes to finish
        waitpid(romeo_pid, NULL, 0);
        waitpid(juliet_pid, NULL, 0);

        // Remove the Romeo and Juliet message queues
        if (msgctl(romeo_queue_id, IPC_RMID, NULL) == -1) {
            perror("msgctl");
            exit(EXIT_FAILURE);
        }

        if (msgctl(juliet_queue_id, IPC_RMID, NULL) == -1) {
            perror("msgctl");
            exit(EXIT_FAILURE);
        }
    }

    return EXIT_SUCCESS;
}