//Falcon-180B DATASET v1.0 Category: Modern Encryption ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define KEY_SIZE 16
#define BLOCK_SIZE 8

void generate_key(unsigned char key[KEY_SIZE]) {
    time_t t;
    time(&t);
    srand(t);

    for (int i = 0; i < KEY_SIZE; i++) {
        key[i] = rand() % 256;
    }
}

void encrypt(unsigned char plaintext[BLOCK_SIZE], unsigned char key[KEY_SIZE], unsigned char ciphertext[BLOCK_SIZE]) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        ciphertext[i] = plaintext[i] ^ key[i];
    }
}

void decrypt(unsigned char ciphertext[BLOCK_SIZE], unsigned char key[KEY_SIZE], unsigned char plaintext[BLOCK_SIZE]) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        plaintext[i] = ciphertext[i] ^ key[i];
    }
}

int main() {
    unsigned char plaintext[BLOCK_SIZE] = "Hello, World!";
    unsigned char key[KEY_SIZE];
    unsigned char ciphertext[BLOCK_SIZE];

    generate_key(key);

    printf("Plaintext: %s\n", plaintext);
    printf("Key: ");
    for (int i = 0; i < KEY_SIZE; i++) {
        printf("%02X ", key[i]);
    }
    printf("\n");

    encrypt(plaintext, key, ciphertext);

    printf("Ciphertext: ");
    for (int i = 0; i < BLOCK_SIZE; i++) {
        printf("%02X ", ciphertext[i]);
    }
    printf("\n");

    decrypt(ciphertext, key, plaintext);

    printf("Decrypted: %s\n", plaintext);

    return 0;
}