//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
    int sockfd;
    struct sockaddr_in servaddr;

    // Creates an IPv4 TCP socket.
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("socket");
        exit(1);
    }

    // Sets up the server address.
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(54321);
    servaddr.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connects to the server.
    if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) == -1) {
        perror("connect");
        exit(1);
    }

    // Sends a message to the server.
    char *msg = "Hello, world!";
    if (send(sockfd, msg, strlen(msg), 0) == -1) {
        perror("send");
        exit(1);
    }

    // Receives a message from the server.
    char recvbuf[1024];
    int recvlen = recv(sockfd, recvbuf, sizeof(recvbuf), 0);
    if (recvlen == -1) {
        perror("recv");
        exit(1);
    }

    // Prints the message from the server.
    printf("%s\n", recvbuf);

    // Closes the socket.
    close(sockfd);

    return 0;
}