//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <pcap.h>

#define SNAP_LEN 65535  // Capture all packets, regardless of the size of the packet

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ip *ip_header = (struct ip *)(packet + 14); // Skip Ethernet header
    printf("Captured a packet from %s to %s\n", inet_ntoa(ip_header->ip_src), inet_ntoa(ip_header->ip_dst));

    // Further analyzing TCP/UDP payload
    if (ip_header->ip_p == IPPROTO_TCP) {
        printf("Protocol: TCP\n");
        struct tcphdr *tcp_header = (struct tcphdr *)(packet + 14 + ip_header->ip_hl * 4);
        printf("Source Port: %d, Destination Port: %d\n",
               ntohs(tcp_header->source), ntohs(tcp_header->dest));
    } else if (ip_header->ip_p == IPPROTO_UDP) {
        printf("Protocol: UDP\n");
        struct udphdr *udp_header = (struct udphdr *)(packet + 14 + ip_header->ip_hl * 4);
        printf("Source Port: %d, Destination Port: %d\n",
               ntohs(udp_header->source), ntohs(udp_header->dest));
    }
    
    printf("\n");
}

int main(int argc, char *argv[]) {
    char *dev;                     
    char errbuf[PCAP_ERRBUF_SIZE]; 
    pcap_t *handle;               
    struct bpf_program fp;        
    char filter_exp[] = "ip";     

    // Check for device parameter
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        return EXIT_FAILURE;
    }

    dev = argv[1];

    // Open the capture device
    handle = pcap_open_live(dev, SNAP_LEN, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return EXIT_FAILURE;
    }

    // Compile filter expression
    if (pcap_compile(handle, &fp, filter_exp, 0, PCAP_NETMASK_UNKNOWN) == -1) {
        fprintf(stderr, "Could not parse filter %s: %s\n", filter_exp, pcap_geterr(handle));
        return EXIT_FAILURE;
    }

    // Apply the filter
    if (pcap_setfilter(handle, &fp) == -1) {
        fprintf(stderr, "Could not install filter %s: %s\n", filter_exp, pcap_geterr(handle));
        return EXIT_FAILURE;
    }

    // Start packet capture loop
    printf("Starting packet capture on %s... Press Ctrl+C to stop.\n", dev);
    pcap_loop(handle, 0, packet_handler, NULL);

    // Cleanup
    pcap_freecode(&fp);
    pcap_close(handle);
    return EXIT_SUCCESS;
}