//LLAMA2-13B DATASET v1.0 Category: Sorting ; Style: romantic
#include <stdio.h>
#include <stdlib.h>

// Declare a struct to represent our romantic couple
struct Couple {
    char *name;
    int age;
};

// Function to compare two couples by age
int compare_by_age(const void *a, const void *b) {
    struct Couple *couple_a = a;
    struct Couple *couple_b = b;
    if (couple_a->age < couple_b->age)
        return -1;
    else if (couple_a->age > couple_b->age)
        return 1;
    else
        return strcmp(couple_a->name, couple_b->name);
}

// Function to sort our list of couples by age
void sort_by_age(struct Couple *couples) {
    qsort(couples, 10, sizeof(struct Couple), compare_by_age);
}

// Function to print our sorted list of couples
void print_couples(struct Couple *couples) {
    int i;
    for (i = 0; i < 10; i++) {
        printf("%s is %d years old\n", couples[i].name, couples[i].age);
    }
}

int main() {
    struct Couple couples[10] = {
        {"Alice", 25},
        {"Bob", 30},
        {"Charlie", 22},
        {"David", 35},
        {"Emily", 28},
        {"Frank", 40},
        {"Grace", 21},
        {"Helen", 32},
        {"Ian", 38},
        {"Jacob", 27}
    };

    // Sort our list of couples by age
    sort_by_age(couples);

    // Print our sorted list of couples
    print_couples(couples);

    return 0;
}