//GEMINI-pro DATASET v1.0 Category: Natural Language Date Converter ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef enum {
  JAN, FEB, MAR, APR, MAY, JUN,
  JUL, AUG, SEP, OCT, NOV, DEC
} Month;

typedef struct {
  int year;
  Month month;
  int day;
} Date;

Date parseDate(char *dateStr) {
  Date date;
  char *monthStrs[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                        "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
  int monthLens[] = {3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
  int i;

  date.year = atoi(dateStr);
  for (i = 0; i < 12; i++) {
    if (strncmp(dateStr, monthStrs[i], monthLens[i]) == 0) {
      date.month = i;
      dateStr += monthLens[i];
      break;
    }
  }
  date.day = atoi(dateStr + 1);

  return date;
}

void printDate(Date date) {
  printf("%d-%d-%d\n", date.year, date.month, date.day);
}

int main() {
  char *dateStrs[] = {"1980-01-01", "2000-02-29", "2023-03-08"};
  int numDateStrs = sizeof(dateStrs) / sizeof(dateStrs[0]);
  int i;

  for (i = 0; i < numDateStrs; i++) {
    Date date = parseDate(dateStrs[i]);
    printDate(date);
  }

  return 0;
}