//GPT-4o-mini DATASET v1.0 Category: Geometric algorithms ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_POINTS 100

typedef struct {
    double x;
    double y;
} Point;

typedef struct {
    Point points[MAX_POINTS];
    int num_points;
} Polygon;

// Function prototypes
void add_point(Polygon *polygon, double x, double y);
double calculate_area(Polygon *polygon);
int is_convex(Polygon *polygon);
void print_polygon(Polygon *polygon);

int main() {
    Polygon polygon;
    polygon.num_points = 0;

    // Example points to create a polygon
    add_point(&polygon, 0, 0);
    add_point(&polygon, 4, 0);
    add_point(&polygon, 4, 3);
    add_point(&polygon, 2, 4);
    add_point(&polygon, 0, 3);

    print_polygon(&polygon);

    double area = calculate_area(&polygon);
    printf("Area of the polygon: %.2f\n", area);

    if (is_convex(&polygon)) {
        printf("The polygon is convex.\n");
    } else {
        printf("The polygon is concave.\n");
    }

    return 0;
}

void add_point(Polygon *polygon, double x, double y) {
    if (polygon->num_points < MAX_POINTS) {
        polygon->points[polygon->num_points].x = x;
        polygon->points[polygon->num_points].y = y;
        polygon->num_points++;
    } else {
        printf("Maximum points reached. Unable to add more.\n");
    }
}

double calculate_area(Polygon *polygon) {
    double area = 0.0;
    int j = polygon->num_points - 1;

    for (int i = 0; i < polygon->num_points; i++) {
        area += (polygon->points[j].x + polygon->points[i].x) * (polygon->points[j].y - polygon->points[i].y);
        j = i;  // j is previous vertex to i
    }

    return fabs(area) / 2.0;
}

int is_convex(Polygon *polygon) {
    int num_points = polygon->num_points;
    if (num_points < 3) {
        return 0; // Not a polygon
    }

    int direction = 0;

    for (int i = 0; i < num_points; i++) {
        double x1 = polygon->points[i].x;
        double y1 = polygon->points[i].y;
        double x2 = polygon->points[(i + 1) % num_points].x;
        double y2 = polygon->points[(i + 1) % num_points].y;
        double x3 = polygon->points[(i + 2) % num_points].x;
        double y3 = polygon->points[(i + 2) % num_points].y;

        double cross_product = (x2 - x1) * (y3 - y2) - (y2 - y1) * (x3 - x2);
        
        if (cross_product != 0) {
            int current_direction = cross_product > 0 ? 1 : -1;
            if (direction == 0) {
                direction = current_direction;
            } else if (current_direction != direction) {
                return 0; // Not Convex
            }
        }
    }
    
    return 1; // Convex
}

void print_polygon(Polygon *polygon) {
    printf("Polygon Points:\n");
    for (int i = 0; i < polygon->num_points; i++) {
        printf("Point %d: (%.2f, %.2f)\n", i + 1, polygon->points[i].x, polygon->points[i].y);
    }
}