//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_LENGTH 100

// Function to calculate the number of set bits in an integer
int count_set_bits(unsigned int num) {
    int count = 0;
    while (num > 0) {
        count += num & 1;
        num >>= 1;
    }
    return count;
}

// Function to reverse the bits in an integer
unsigned int reverse_bits(unsigned int num) {
    unsigned int reversed = 0;
    for (int i = 0; i < 32; i++) {
        reversed |= (num >> i) & 1;
    }
    return reversed;
}

// Function to toggle the nth bit in an integer
unsigned int toggle_bit(unsigned int num, int n) {
    unsigned int mask = 1 << n;
    return num ^ mask;
}

// Function to get the nth bit in an integer
int get_bit(unsigned int num, int n) {
    unsigned int mask = 1 << n;
    return (num & mask) >> n;
}

// Function to set the nth bit in an integer
unsigned int set_bit(unsigned int num, int n) {
    unsigned int mask = 1 << n;
    return num | mask;
}

// Function to clear the nth bit in an integer
unsigned int clear_bit(unsigned int num, int n) {
    unsigned int mask = ~(1 << n);
    return num & mask;
}

// Function to check if a string is a palindrome
int is_palindrome(char* str) {
    int len = strlen(str);
    for (int i = 0; i < len / 2; i++) {
        if (tolower(str[i])!= tolower(str[len - i - 1])) {
            return 0;
        }
    }
    return 1;
}

// Function to print a binary representation of an integer
void print_binary(unsigned int num) {
    char binary[33];
    int i = 0;
    while (num > 0) {
        binary[i++] = (num & 1) + '0';
        num >>= 1;
    }
    printf("%s\n", binary);
}

int main() {
    // Example usage of bitwise functions
    unsigned int num = 0b10101010;
    printf("Number of set bits: %d\n", count_set_bits(num));
    printf("Reversed bits: %u\n", reverse_bits(num));
    printf("Toggle 4th bit: %u\n", toggle_bit(num, 4));
    printf("Get 5th bit: %d\n", get_bit(num, 5));
    printf("Set 6th bit: %u\n", set_bit(num, 6));
    printf("Clear 7th bit: %u\n", clear_bit(num, 7));

    // Example usage of string functions
    char str1[] = "racecar";
    char str2[] = "hello";
    printf("Is %s a palindrome? %s\n", str1, is_palindrome(str1)? "Yes" : "No");
    printf("Is %s a palindrome? %s\n", str2, is_palindrome(str2)? "Yes" : "No");

    return 0;
}